/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.rss.robot;

import java.io.IOException;
import org.logical_paradox.rss.RSSIllegalConfigException;
import org.logical_paradox.rss.RSSNullValueException;
import org.logical_paradox.rss.RSSValueFormatException;
import org.logical_paradox.rss.dsync.RSSSyncConfig;
import org.logical_paradox.rss.router.algorithm.RoutingAlgorithm;

public class RSSNavigatorConfig
extends RSSSyncConfig {
    public static final boolean NAVIMODE_DISTRIB = true;
    public static final boolean NAVIMODE_STANDALONE = false;
    private String cfgHttpUserAgent = "RSS-agent/1b (http://www.logical-paradox.org/)";
    private int cfgKeepLocks = 300;
    private int cfgKeepUrls = 1600;
    private int cfgUnTracedURLSendCnt = 20;
    private int cfgDebugTraceURLs = 50;
    private boolean cfgNaviSwRunLog = false;
    private String cfgNavigatorRunLogFilename = "rssnavigator.run.log";
    private boolean cfgNavigationMode = true;
    private boolean cfgEchoURL = true;
    private String cfgRoot = "";
    private long cfgSiteLockExpire = 300000L;
    private RoutingAlgorithm cfgRoutingAlgorithm = null;
    private int cfgNavigatorSyncInterval = 10000;
    private String cfgDistServRegURL;

    public RSSNavigatorConfig(String fn) throws IOException, RSSIllegalConfigException {
        super(fn);
        String errmsg = this.checkResourceVariables();
        if (errmsg != null) {
            throw new RSSIllegalConfigException(errmsg);
        }
    }

    public String getDistServRegURL() {
        return this.cfgDistServRegURL;
    }

    public boolean getEchoURL() {
        return this.cfgEchoURL;
    }

    public String getHttpUserAgent() {
        return this.cfgHttpUserAgent;
    }

    public int getDebugTraceURLs() {
        return this.cfgDebugTraceURLs;
    }

    public int getKeepLocks() {
        return this.cfgKeepLocks;
    }

    public int getKeepUrls() {
        return this.cfgKeepUrls;
    }

    public int getUnTracedURLSendCnt() {
        return this.cfgUnTracedURLSendCnt;
    }

    public boolean getNaviSwRunLog() {
        return this.cfgNaviSwRunLog;
    }

    public String getNavigatorRunLogFilename() {
        return this.cfgNavigatorRunLogFilename;
    }

    public boolean getNavigationMode() {
        return this.cfgNavigationMode;
    }

    public String getRoot() {
        return this.cfgRoot;
    }

    public long getSiteLockExpire() {
        return this.cfgSiteLockExpire;
    }

    public RoutingAlgorithm getRoutingAlgorithm() {
        return this.cfgRoutingAlgorithm;
    }

    public int getNavigatorSyncInterval() {
        return this.cfgNavigatorSyncInterval;
    }

    protected String checkResourceVariables() {
        String errmsg = super.checkResourceVariables();
        if (this.getProperty("HTTP_USER_AGENT") != null) {
            this.cfgHttpUserAgent = this.getProperty("HTTP_USER_AGENT");
        }
        this.cfgDistServRegURL = this.getProperty("RSS_DSR");
        if (this.cfgDistServRegURL == null) {
            errmsg = String.valueOf(errmsg) + "RSS_DSR\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\n";
        }
        try {
            this.cfgKeepLocks = this.getPropertyAsInt("KEEP_LOCKS");
        }
        catch (RSSValueFormatException vfe) {
            errmsg = String.valueOf(errmsg) + "KEEP_LOCKS\u306e\u5024\u304c\u4e0d\u6b63\u3067\u3059\n";
        }
        catch (RSSNullValueException vfe) {
            // empty catch block
        }
        try {
            this.cfgKeepUrls = this.getPropertyAsInt("KEEP_URLS");
        }
        catch (RSSValueFormatException vfe) {
            errmsg = String.valueOf(errmsg) + "KEEP_URLS\u306e\u5024\u304c\u4e0d\u6b63\u3067\u3059\n";
        }
        catch (RSSNullValueException vfe) {
            // empty catch block
        }
        try {
            this.cfgUnTracedURLSendCnt = this.getPropertyAsInt("UNTRACED_URL_SEND_CNT");
        }
        catch (RSSValueFormatException vfe) {
            errmsg = String.valueOf(errmsg) + "UNTRACED_URL_SEND_CNT\u306e\u5024\u304c\u4e0d\u6b63\u3067\u3059\n";
        }
        catch (RSSNullValueException vfe) {
            // empty catch block
        }
        try {
            this.cfgDebugTraceURLs = this.getPropertyAsInt("DEBUG_TRACE_URLS");
        }
        catch (RSSValueFormatException vfe) {
            errmsg = String.valueOf(errmsg) + "DEBUG_TRACE_URLS\u306e\u5024\u304c\u4e0d\u6b63\u3067\u3059";
        }
        catch (RSSNullValueException vfe) {
            // empty catch block
        }
        try {
            this.cfgNaviSwRunLog = this.getPropertyAsBool("NAVI_SW_RUNLOG");
        }
        catch (RSSValueFormatException vfe) {
            errmsg = String.valueOf(errmsg) + "NAVI_SW_RUNLOG\u306e\u5024\u304c\u4e0d\u6b63\u3067\u3059";
        }
        catch (RSSNullValueException vfe) {
            // empty catch block
        }
        try {
            this.cfgEchoURL = this.getPropertyAsBool("ECHO_URL");
        }
        catch (RSSValueFormatException vfe) {
            errmsg = String.valueOf(errmsg) + "ECHO_URL\u306e\u5024\u304c\u4e0d\u6b63\u3067\u3059";
        }
        catch (RSSNullValueException vfe) {
            // empty catch block
        }
        this.cfgNavigatorRunLogFilename = this.getProperty("NAVIGATOR_RUNLOG_FILENAME");
        String cfgSNavigationMode = this.getProperty("NAVIGATION_MODE");
        if (cfgSNavigationMode == null || cfgSNavigationMode.trim().toUpperCase().equals("DISTRIB")) {
            this.cfgNavigationMode = true;
        } else if (cfgSNavigationMode.trim().toUpperCase().equals("STANDALONE")) {
            this.cfgNavigationMode = false;
        } else {
            errmsg = String.valueOf(errmsg) + "NAVIGATION_MODE\u304c\u4e0d\u6b63\u3067\u3059";
        }
        this.cfgRoot = this.getProperty("ROOT");
        try {
            this.cfgSiteLockExpire = this.getPropertyAsInt("SITELOCK_EXPIRE");
            if (this.cfgSiteLockExpire < 0L) {
                throw new RSSValueFormatException();
            }
        }
        catch (RSSValueFormatException vfe) {
            errmsg = String.valueOf(errmsg) + "SITELOCK_EXPIRE\u306f0\u4ee5\u4e0a\u306b\u8a2d\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\n";
        }
        catch (RSSNullValueException vfe) {
            // empty catch block
        }
        try {
            this.cfgNavigatorSyncInterval = this.getPropertyAsInt("NAVIGATOR_SYNC_INTERVAL");
            if (this.cfgNavigatorSyncInterval < 500) {
                throw new RSSValueFormatException();
            }
        }
        catch (RSSValueFormatException vfe) {
            errmsg = String.valueOf(errmsg) + "NAVIGATOR_SYNC_INTERVAL\u306f500\u4ee5\u4e0a\u306b\u8a2d\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\n";
        }
        catch (RSSNullValueException vfe) {
            // empty catch block
        }
        try {
            String algorithm = this.getProperty("ROUTING_ALGORITHM");
            this.cfgRoutingAlgorithm = (RoutingAlgorithm)Class.forName(algorithm).newInstance();
        }
        catch (Exception e) {
            errmsg = String.valueOf(errmsg) + "ROUTING_ALGORITHM\u3067\u5b9a\u7fa9\u3055\u308c\u305f\u7d4c\u8def\u6c7a\u5b9a\u30a2\u30eb\u30b4\u30ea\u30ba\u30e0\u306f\uff0c\u5b58\u5728\u3057\u307e\u305b\u3093\n";
        }
        if (errmsg.trim().length() > 0) {
            return errmsg;
        }
        return null;
    }
}

