/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.rss.robot;

import HTTPClient.NVPair;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.TooManyListenersException;
import org.logical_paradox.rss.IllegalObjectStateException;
import org.logical_paradox.rss.http.RSSHttpResponse;
import org.logical_paradox.rss.http.RSSHttpURLConnection;
import org.logical_paradox.rss.http.WebContents;
import org.logical_paradox.rss.logging.RSSDebugLogWriter;
import org.logical_paradox.rss.robot.RSSWebSpiderRobot;
import org.logical_paradox.rss.robot.event.RSSWSAgentEvent;
import org.logical_paradox.rss.robot.event.RSSWSAgentListener;

public class RSSWebSpiderAgent
extends Thread {
    private RSSHttpURLConnection con = null;
    private String content = null;
    private RSSWSAgentListener eventListener = null;
    private boolean running = false;
    private RSSWebSpiderRobot robot = null;

    public RSSWebSpiderAgent(RSSWebSpiderRobot r) {
        this.robot = r;
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setup(String remoteHost, int timeoutSec) throws MalformedURLException, IOException, TooManyListenersException {
        RSSDebugLogWriter.write("\u30b9\u30ec\u30c3\u30c9\u306e\u30bb\u30c3\u30c8\u30a2\u30c3\u30d7\u3092\u3057\u3066\u3044\u307e\u3059");
        NVPair[] nvp = new NVPair[]{new NVPair("User-Agent", this.robot.getSpiderConfig().getHttpUserAgent()), new NVPair("Cache-Control", "no-cache")};
        URL dest = new URL(remoteHost);
        RSSHttpURLConnection c = new RSSHttpURLConnection(new URL(remoteHost));
        c.setDefaultHeaders(nvp);
        c.setTimeout(timeoutSec);
        try {
            c.removeModule(Class.forName("HTTPClient.CookieModule"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.con = c;
        RSSDebugLogWriter.write("\u30b9\u30ec\u30c3\u30c9\u306e\u30bb\u30c3\u30c8\u30a2\u30c3\u30d7\u3092\u5b8c\u4e86\u3057\u307e\u3057\u305f");
    }

    public String getRemoteHost() throws IllegalObjectStateException {
        if (this.con == null) {
            throw new IllegalObjectStateException();
        }
        return this.con.getURL().toString();
    }

    public void run() {
        super.run();
        while (true) {
            Exception e3;
            Object var5_6;
            RSSDebugLogWriter.write("\u30b9\u30ec\u30c3\u30c9\u304c\u63a5\u7d9a\u3092\u958b\u59cb\u3057\u307e\u3057\u305f");
            this.sendOnConnectEvent(new RSSWSAgentEvent(this));
            boolean rc = this.robot.AtTheBeginningOfAgentCallback(this);
            if (!rc) {
                this.robot.AtTheEndOfAgentCallback(this);
                return;
            }
            this.running = true;
            RSSDebugLogWriter.write("\u30b9\u30ec\u30c3\u30c9\u304crun()\u3092\u958b\u59cb\u3057\u307e\u3057\u305f");
            RSSDebugLogWriter.write("URL: " + this.con.getURL().toString());
            RSSHttpResponse res = null;
            try {
                try {
                    String forwardedTo;
                    res = new RSSHttpResponse(this.con.Get(), "8859_1");
                    int responseCode = res.getResponseCode();
                    if (!this.robot.getSpiderConfig().isEnabledContentType(res.getHeader("Content-Type"))) {
                        this.content = null;
                    } else if (responseCode == 200) {
                        RSSDebugLogWriter.write("\u30b9\u30ec\u30c3\u30c9\u304c\u30b3\u30f3\u30c6\u30f3\u30c4\u306e\u8aad\u307f\u8fbc\u307f\u3092\u59cb\u3081\u307e\u3057\u305f");
                        this.content = res.getText();
                        RSSDebugLogWriter.write("\u30b9\u30ec\u30c3\u30c9\u304c\u63a5\u7d9a\u3092\u9589\u3058\u3066\u3044\u307e\u3059");
                    } else if ((responseCode == 301 || responseCode == 302) && (forwardedTo = res.getHeader("Location")) != null) {
                        System.err.println("\u8ee2\u9001\u5148:" + forwardedTo);
                    }
                }
                catch (Exception e2) {
                    String errmsg = "failed";
                    if (res != null) {
                        errmsg = String.valueOf(errmsg) + "(" + res.getResponseCode() + ")";
                    }
                    errmsg = String.valueOf(errmsg) + " : " + this.con.getURL().toString();
                    System.err.println(errmsg);
                    RSSDebugLogWriter.write(errmsg);
                    this.content = null;
                }
            }
            catch (Throwable throwable) {
                var5_6 = null;
                this.running = false;
                RSSDebugLogWriter.write("\u30b9\u30ec\u30c3\u30c9\u304conClose()\u30a4\u30d9\u30f3\u30c8\u3092\u767a\u884c\u3057\u3066\u3044\u307e\u3059");
                try {
                    this.sendOnCloseEvent(new RSSWSAgentEvent(this, new WebContents(res, this.content)));
                }
                catch (Exception e3) {
                    // empty catch block
                }
                throw throwable;
            }
            var5_6 = null;
            this.running = false;
            RSSDebugLogWriter.write("\u30b9\u30ec\u30c3\u30c9\u304conClose()\u30a4\u30d9\u30f3\u30c8\u3092\u767a\u884c\u3057\u3066\u3044\u307e\u3059");
            try {
                this.sendOnCloseEvent(new RSSWSAgentEvent(this, new WebContents(res, this.content)));
            }
            catch (Exception e3) {
            }
        }
    }

    public void addRSSWSAgentListener(RSSWSAgentListener listener) throws TooManyListenersException {
        if (this.eventListener != null) {
            throw new TooManyListenersException();
        }
        this.eventListener = listener;
    }

    public void removeRSSWSAgentListener() {
        this.eventListener = null;
    }

    public void sendOnConnectEvent(RSSWSAgentEvent e) {
        this.eventListener.onConnect(e);
    }

    public void sendOnCloseEvent(RSSWSAgentEvent e) {
        this.eventListener.onClose(e);
    }
}

