/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.rss.robot;

import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.logical_paradox.rss.RSSConfig;
import org.logical_paradox.rss.RSSIllegalConfigException;
import org.logical_paradox.rss.RSSNullValueException;
import org.logical_paradox.rss.RSSValueFormatException;

public class RSSWebSpiderConfig
extends RSSConfig {
    private String cfgHttpUserAgent = "RSS-agent/1b (http://www.logical-paradox.org/)";
    private int cfgAgentsPerRobot = 1;
    private int cfgAgentConnectionTimeoutSec = 30000;
    private boolean cfgRobotSwDebugTraceLog = false;
    private boolean cfgRobotSwRunLog = false;
    private String cfgDebugTraceLogFilename = "rss.debug.trace.log";
    private String cfgRobotRunLogFilename = "rsswebspider.run.log";
    private String[] cfgAllowedContentType = null;

    public RSSWebSpiderConfig(String fn) throws IOException, RSSIllegalConfigException {
        super(fn);
        String errmsg = this.checkResourceVariables();
        if (errmsg != null) {
            throw new RSSIllegalConfigException(errmsg);
        }
    }

    public String getHttpUserAgent() {
        return this.cfgHttpUserAgent;
    }

    public int getAgentsPerRobot() {
        return this.cfgAgentsPerRobot;
    }

    public int getAgentConnectionTimeoutSec() {
        return this.cfgAgentConnectionTimeoutSec;
    }

    public boolean getRobotSwDebugTraceLog() {
        return this.cfgRobotSwDebugTraceLog;
    }

    public boolean getRobotSwRunLog() {
        return this.cfgRobotSwRunLog;
    }

    public String getDebugTraceLogFilename() {
        return this.cfgDebugTraceLogFilename;
    }

    public String getRobotRunLogFilename() {
        return this.cfgRobotRunLogFilename;
    }

    public String[] getAllowedContentType() {
        return this.cfgAllowedContentType;
    }

    public boolean isEnabledContentType(String ct) {
        if (this.cfgAllowedContentType == null || this.cfgAllowedContentType.length == 0) {
            return true;
        }
        int i = 0;
        while (i < this.cfgAllowedContentType.length) {
            if (ct.indexOf(this.cfgAllowedContentType[i]) >= 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected String checkResourceVariables() {
        String errmsg = "";
        if (this.getProperty("HTTP_USER_AGENT") != null) {
            this.cfgHttpUserAgent = this.getProperty("HTTP_USER_AGENT");
        }
        try {
            this.cfgAgentsPerRobot = this.getPropertyAsInt("AGENTS_PER_ROBOT");
        }
        catch (RSSValueFormatException vfe) {
            errmsg = String.valueOf(errmsg) + "AGENTS_PER_ROBOT\u306e\u5024\u304c\u4e0d\u6b63\u3067\u3059\n";
        }
        catch (RSSNullValueException vfe) {
            // empty catch block
        }
        try {
            this.cfgAgentConnectionTimeoutSec = this.getPropertyAsInt("AGENT_CONNECTION_TIMEOUT_SEC");
        }
        catch (RSSValueFormatException vfe) {
            errmsg = String.valueOf(errmsg) + "AGENT_CONNECTION_TIMEOUT_SEC\u306e\u5024\u304c\u4e0d\u6b63\u3067\u3059";
        }
        catch (RSSNullValueException vfe) {
            // empty catch block
        }
        try {
            this.cfgRobotSwDebugTraceLog = this.getPropertyAsBool("ROBOT_SW_DEBUG_TRACE_LOG");
        }
        catch (RSSValueFormatException vfe) {
            errmsg = String.valueOf(errmsg) + "ROBOT_SW_DEBUG_TRACE_LOG\u306e\u5024\u304c\u4e0d\u6b63\u3067\u3059";
        }
        catch (RSSNullValueException vfe) {
            // empty catch block
        }
        try {
            this.cfgRobotSwRunLog = this.getPropertyAsBool("ROBOT_SW_RUNLOG");
        }
        catch (RSSValueFormatException vfe) {
            errmsg = String.valueOf(errmsg) + "ROBOT_SW_RUNLOG\u306e\u5024\u304c\u4e0d\u6b63\u3067\u3059";
        }
        catch (RSSNullValueException vfe) {
            // empty catch block
        }
        this.cfgDebugTraceLogFilename = this.getProperty("DEBUG_TRACE_LOG_FILENAME");
        this.cfgRobotRunLogFilename = this.getProperty("ROBOT_RUNLOG_FILENAME");
        String contentTypes = this.getProperty("ALLOWED_CONTENT_TYPE");
        if (contentTypes == null || contentTypes.trim().length() == 0) {
            this.cfgAllowedContentType = new String[0];
        } else {
            ArrayList<String> types = new ArrayList<String>();
            StringTokenizer t = new StringTokenizer(contentTypes.trim(), ",");
            while (t.hasMoreTokens()) {
                types.add(t.nextToken().trim());
            }
            this.cfgAllowedContentType = types.toArray(new String[0]);
        }
        if (errmsg.trim().length() > 0) {
            return errmsg;
        }
        return null;
    }
}

