/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.rss.router;

import java.io.File;
import java.io.FileOutputStream;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.logical_paradox.rss.ModuleException;
import org.logical_paradox.rss.RSSSubModule;
import org.logical_paradox.rss.dsync.SyncCommand;
import org.logical_paradox.rss.dsync.SyncQueue;
import org.logical_paradox.rss.dsync.SyncQueueException;
import org.logical_paradox.rss.http.URLPool;
import org.logical_paradox.rss.logging.RSSDebugLogWriter;
import org.logical_paradox.rss.logging.RSSLogWriter;
import org.logical_paradox.rss.lookup.LookupFactory;
import org.logical_paradox.rss.router.RNodeClientFactory;
import org.logical_paradox.rss.router.RSSRoutingNodeConfig;
import org.logical_paradox.rss.router.RSSRoutingNodeLogWriter;
import org.logical_paradox.rss.router.RoutingNodeClient;
import org.logical_paradox.rss.router.RoutingNodeClientImpl;
import org.logical_paradox.rss.router.algorithm.AllocatingAlgorithm;
import org.logical_paradox.rss.router.algorithm.AllocationException;

public class RNodeClientFactoryImpl
extends UnicastRemoteObject
implements RNodeClientFactory,
RSSSubModule {
    public static final String RSS_ROUTING_NODE_CONFIG = "conf/rssroutingfactory.conf";
    private Hashtable searchNodes = null;
    private String factoryServiceName = null;
    private RSSRoutingNodeConfig config = null;
    private URLPool unTracedURLs = null;
    private int rnodeClientCapacity = 32;
    private SyncQueue syncQueue = new SyncQueue();
    private SyncQueue rejectedCommandQueue = new SyncQueue();
    private AllocatingAlgorithm allocater = null;

    public RNodeClientFactoryImpl() throws RemoteException {
    }

    public void init(String DSRURL) throws RemoteException {
        if (DSRURL == null || DSRURL.trim().length() == 0) {
            throw new RemoteException("dsr service name is empty");
        }
        this.unTracedURLs = new URLPool();
        this.searchNodes = new Hashtable();
        try {
            RSSRoutingNodeLogWriter.write("\u5206\u6563\u30b5\u30fc\u30d3\u30b9\u30ec\u30b8\u30b9\u30c8\u30ea'" + DSRURL + "'\u306b\u30b5\u30fc\u30d3\u30b9\u30a4\u30f3\u3057\u3066\u3044\u307e\u3059");
            this.factoryServiceName = LookupFactory.getLookup(DSRURL).bind(10, this);
            RSSRoutingNodeLogWriter.write("\u7d4c\u8def\u6c7a\u5b9a\u30ce\u30fc\u30c9: " + this.getNodeId());
            RSSRoutingNodeLogWriter.write("\u30b5\u30fc\u30d3\u30b9\u30a4\u30f3\u306b\u6210\u529f\u3057\u307e\u3057\u305f");
        }
        catch (Exception e) {
            RSSRoutingNodeLogWriter.write("\u30b5\u30fc\u30d3\u30b9\u30a4\u30f3\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
            throw (RemoteException)e;
        }
    }

    public RNodeClientFactoryImpl(String selectorServiceUrl) throws RemoteException {
        this.init(selectorServiceUrl);
    }

    public String getNodeId() throws RemoteException {
        return this.factoryServiceName;
    }

    public RoutingNodeClient bindSearchNode() throws RemoteException {
        RSSRoutingNodeLogWriter.write("\u63a2\u7d22\u30ce\u30fc\u30c9\u3092\u30d0\u30a4\u30f3\u30c9\u3057\u3066\u3044\u307e\u3059");
        RoutingNodeClient client = this.attachSearchNode();
        try {
            RSSRoutingNodeLogWriter.write("\u63a2\u7d22\u30ce\u30fc\u30c9\u304c\uff0c\u540d\u524d'" + client.getNodeId() + "'\u3068\u3057\u3066\u767b\u9332\u3055\u308c\u307e\u3057\u305f");
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage());
        }
        return client;
    }

    public void unbindSearchNode(String robotId) throws RemoteException {
        RSSRoutingNodeLogWriter.write("\u63a2\u7d22\u30ce\u30fc\u30c9'" + robotId + "'\u3092\u5207\u308a\u96e2\u3057\u3066\u3044\u307e\u3059");
        boolean exitf = true;
        if (this.detachSearchNode(robotId)) {
            exitf = false;
        }
        if (exitf) {
            RSSRoutingNodeLogWriter.write("\u7ba1\u7406\u3055\u308c\u3066\u3044\u306a\u3044\u63a2\u7d22\u30ce\u30fc\u30c9'" + robotId + "'\u3092\u5207\u308a\u96e2\u305d\u3046\u3068\u3057\u307e\u3057\u305f");
            throw new RemoteException("no routing manager manages the robot '" + robotId + "'.");
        }
        RSSRoutingNodeLogWriter.write("\u63a2\u7d22\u30ce\u30fc\u30c9'" + robotId + "'\u304c\u5207\u308a\u96e2\u3055\u308c\u307e\u3057\u305f");
    }

    public RoutingNodeClient attachSearchNode() throws RemoteException {
        RoutingNodeClientImpl rn = new RoutingNodeClientImpl(this);
        this.searchNodes.put(rn.getNodeId(), rn);
        this.allocater.addChildNode(rn.getNodeId());
        return rn;
    }

    public boolean detachSearchNode(String robotId) {
        boolean rc = false;
        Hashtable hashtable = this.searchNodes;
        synchronized (hashtable) {
            RoutingNodeClient rnc = (RoutingNodeClient)this.searchNodes.get(robotId);
            if (rnc == null || this.searchNodes.remove(robotId) == null) {
                rc = false;
            } else {
                this.allocater.removeChildNode(robotId);
                rc = true;
            }
        }
        return rc;
    }

    public void removeUnTracedURL(String url) throws RemoteException {
        try {
            URLPool uRLPool = this.unTracedURLs;
            synchronized (uRLPool) {
                this.unTracedURLs.remove(url);
            }
        }
        catch (MalformedURLException ue) {
            throw new RemoteException(ue.getMessage());
        }
    }

    public void addUnTracedURL(String url) throws RemoteException {
        try {
            this.unTracedURLs.add(url);
        }
        catch (MalformedURLException ue) {
            throw new RemoteException(ue.getMessage());
        }
    }

    public void allocateURL() {
        try {
            URLPool uRLPool = this.unTracedURLs;
            synchronized (uRLPool) {
                String[] domains = this.unTracedURLs.domains();
                int i = 0;
                while (i < domains.length) {
                    String domain = domains[i];
                    String[] urls = this.unTracedURLs.urls(domain);
                    int j = 0;
                    while (j < urls.length) {
                        try {
                            String destNodeId = this.allocater.allocate(urls[j]);
                            this.rejectedCommandQueue.add(new SyncCommand(urls[j], 3, this.getNodeId(), destNodeId));
                            this.unTracedURLs.remove(urls[j]);
                        }
                        catch (RemoteException re) {
                            re.printStackTrace();
                        }
                        catch (AllocationException ae) {
                            ae.printStackTrace();
                        }
                        catch (SyncQueueException syncQueueException) {
                        }
                        catch (MalformedURLException malformedURLException) {
                            // empty catch block
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public String[] getAllowedRoutingIPRanges() throws RemoteException {
        return this.config.getRoutingIPRanges();
    }

    public String[] getClientNames() throws RemoteException {
        Vector tmp = new Vector();
        Hashtable hashtable = this.searchNodes;
        synchronized (hashtable) {
            Enumeration e = this.searchNodes.keys();
            while (e.hasMoreElements()) {
                tmp.addElement(e.nextElement());
            }
        }
        if (tmp.size() == 0) {
            return null;
        }
        return tmp.toArray(new String[1]);
    }

    public SyncCommand[] getModifiedSyncData(String rk) throws RemoteException {
        this.allocateURL();
        SyncCommand[] o = this.rejectedCommandQueue.get(rk);
        this.rejectedCommandQueue.clear(rk);
        return o;
    }

    public void sync(SyncCommand[] locks) throws Exception {
        if (locks == null || locks.length == 0) {
            return;
        }
        RSSDebugLogWriter.write(String.valueOf(locks.length) + "\u4ef6\u306e\u540c\u671f\u30c7\u30fc\u30bf\u3092\u53d7\u4fe1\u3057\u307e\u3057\u305f");
        Vector<SyncCommand> receivedCommands = new Vector<SyncCommand>(Arrays.asList(locks));
        SyncCommand[] rejectedCommands = this.syncQueue.add(locks);
        receivedCommands.removeAll(Arrays.asList(rejectedCommands));
        int i = 0;
        while (i < receivedCommands.size()) {
            SyncCommand command = receivedCommands.elementAt(i);
            if (command.getType() == 3) {
                this.unTracedURLs.add((String)command.getObject());
            }
            ++i;
        }
        this.rejectedCommandQueue.add(rejectedCommands);
    }

    public static void main(String[] args) {
        try {
            RNodeClientFactoryImpl factory = new RNodeClientFactoryImpl();
            factory.startModule();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }

    public void startModule() throws ModuleException {
        try {
            RSSRoutingNodeConfig conf = new RSSRoutingNodeConfig(RSS_ROUTING_NODE_CONFIG);
            RSSRoutingNodeLogWriter.setLogWriter(new RSSLogWriter(new FileOutputStream("logs" + File.separator + conf.getFactoryRunLogFilename(), true)));
            RSSRoutingNodeLogWriter.setLoggingMode(conf.getFactorySwRunLog());
            RSSRoutingNodeLogWriter.write("\u30ed\u30b0\u30e9\u30a4\u30bf\u30fc\u3092\u521d\u671f\u5316\u3057\u307e\u3057\u305f");
            this.init(conf.getRSSDSR());
            this.rnodeClientCapacity = conf.getRSSRNodeClientCapacity();
            this.allocater = conf.getAllocatingAlgorithm();
            this.allocater.setRoutingAlgorithm(conf.getRoutingAlgorithm());
            String defaultURLsLine = conf.getRSSFactoryDefaultURLs();
            if (defaultURLsLine != null) {
                String[] defaultURLs = defaultURLsLine.split(",");
                int i = 0;
                while (i < defaultURLs.length) {
                    this.addUnTracedURL(defaultURLs[i]);
                    ++i;
                }
            }
            this.config = conf;
            System.err.println("RNodeClientFactory '" + this.factoryServiceName + "' is started");
            RSSRoutingNodeLogWriter.write("\u7d4c\u8def\u6c7a\u5b9a\u30ce\u30fc\u30c9\u30af\u30e9\u30a4\u30a2\u30f3\u30c8\u30d5\u30a1\u30af\u30c8\u30ea\u30b5\u30fc\u30d3\u30b9'" + this.factoryServiceName + "'\u304c\u958b\u59cb\u3055\u308c\u307e\u3057\u305f");
        }
        catch (Exception e) {
            throw new ModuleException(e);
        }
    }

    public void suspendModule() throws ModuleException {
    }

    public void continueModule() throws ModuleException {
    }

    public void stopModule() throws ModuleException {
    }

    public String getName() throws RemoteException {
        return this.factoryServiceName;
    }

    public String getFqsn() throws RemoteException {
        return String.valueOf(this.factoryServiceName) + "@" + this.config.getRSSDSR();
    }
}

