/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.rss.router;

import java.util.Vector;
import org.logical_paradox.common.net.IPAddressRangeSet;
import org.logical_paradox.rss.dsync.RSSSyncConfig;
import org.logical_paradox.rss.dsync.RSSSyncDaemon;
import org.logical_paradox.rss.dsync.RSSSyncInterface;
import org.logical_paradox.rss.dsync.SyncCommand;
import org.logical_paradox.rss.dsync.SyncQueueException;
import org.logical_paradox.rss.http.URLPool;
import org.logical_paradox.rss.router.RestrictedSiteLockMgr;
import org.logical_paradox.rss.router.SiteLock;

public class RNodeDSyncMngr
extends RSSSyncDaemon {
    private final RestrictedSiteLockMgr lockMgr;
    private final URLPool pool;

    public RNodeDSyncMngr(RSSSyncConfig daemonConfig, RSSSyncInterface dsi, long maxlocks, URLPool p, IPAddressRangeSet rs) throws Exception {
        super(daemonConfig, dsi);
        this.lockMgr = new RestrictedSiteLockMgr(maxlocks, rs);
        this.pool = p;
    }

    public boolean lock(SiteLock l) throws SyncQueueException {
        boolean rc = this.lockMgr.lock(l);
        if (rc) {
            this.add(new SyncCommand(l, 1, null, null));
        }
        return rc;
    }

    public SiteLock findLock(String dn, String rid) {
        return this.lockMgr.findLock(dn, rid);
    }

    public SiteLock[] gc() {
        SiteLock[] removedObjLocal = this.lockMgr.gc();
        Vector<SiteLock> removedObjRemote = new Vector<SiteLock>();
        try {
            int i = 0;
            while (i < removedObjLocal.length) {
                this.unlock(removedObjLocal[i]);
                removedObjRemote.addElement(removedObjLocal[i]);
                ++i;
            }
        }
        catch (SyncQueueException syncQueueException) {
            // empty catch block
        }
        return removedObjRemote.toArray(new SiteLock[1]);
    }

    public int numOfMyLocks(String robotId) {
        return this.lockMgr.numOfMyLocks(robotId);
    }

    public URLPool getPool() {
        return this.pool;
    }

    public void unlock(SiteLock l) throws SyncQueueException {
        this.lockMgr.unlock(l);
        this.add(new SyncCommand(l, -1, null, null));
    }

    public void poolURL(String url) throws SyncQueueException {
        this.add(new SyncCommand(url, 3, null, null));
    }

    public void dropURL(String url) throws SyncQueueException {
        this.add(new SyncCommand(url, -3, null, null));
    }

    public void done() {
        this.interrupt();
    }
}

