/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.rss.router.algorithm;

import java.util.HashMap;
import org.logical_paradox.rss.router.algorithm.AllocationException;
import org.logical_paradox.rss.router.algorithm.RoutingAlgorithm;

public abstract class AllocatingAlgorithm {
    private RoutingAlgorithm algo = null;
    protected HashMap childNode = new HashMap();

    public void addChildNode(String nodeId) {
        HashMap hashMap = this.childNode;
        synchronized (hashMap) {
            this.childNode.put(nodeId, nodeId);
        }
    }

    public void addChildNode(String[] nodeId) {
        int i = 0;
        while (i < nodeId.length) {
            this.addChildNode(nodeId[i]);
            ++i;
        }
    }

    public void removeChildNode(String nodeId) {
        this.childNode.remove(nodeId);
    }

    public abstract String allocate(String var1) throws AllocationException;

    public void setRoutingAlgorithm(RoutingAlgorithm ra) {
        this.algo = ra;
    }

    public void removeRoutingAlgorithm() {
        this.algo = null;
    }

    public boolean hasRoutingAlgorithm() {
        return this.algo != null;
    }
}

