/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.rss.router.algorithm;

import java.net.MalformedURLException;
import java.util.Iterator;
import java.util.LinkedList;
import org.logical_paradox.rss.http.URLPool;
import org.logical_paradox.rss.router.algorithm.RoutingAlgorithm;

public class LBRoutingAlgorithm
extends RoutingAlgorithm {
    public static final int REQ_DOMAINS_PER_TIME = 20;
    public static final int HISTORY_PRIO_BUFSIZE = 20;
    private URLHistoryPrio prio = new URLHistoryPrio(20);
    private int lastRefIdx = 0;

    public String getAlgorithmName() {
        return "Load Balanced Routing Algorithm";
    }

    public String nextURL(URLPool urls) {
        String rc = null;
        boolean exitf = true;
        do {
            if (urls.size() == 0) {
                rc = null;
                exitf = false;
                continue;
            }
            String dn = this.getNextSite(urls);
            Iterator i = urls.getURLIterator(dn);
            if (i == null) {
                return null;
            }
            rc = (String)i.next();
            try {
                urls.remove(rc);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            if (this.history.isTraced(rc)) continue;
            this.history.add(rc);
            exitf = false;
        } while (exitf);
        return rc;
    }

    private String getNextSite(URLPool urls) {
        String rc = null;
        String[] domains = urls.domains();
        if (domains == null) {
            return null;
        }
        int looptime = domains.length >= 20 ? 20 : domains.length;
        int idx = this.lastRefIdx;
        int highscore = 21;
        int priority = 0;
        int i = 0;
        while (i < looptime) {
            String dn;
            if (idx >= domains.length) {
                idx = 0;
            }
            if ((priority = this.prio.indexOf(dn = domains[idx])) <= highscore) {
                highscore = priority;
                rc = dn;
            }
            if (priority == -1) break;
            ++idx;
            ++i;
        }
        if (rc != null) {
            this.lastRefIdx = idx;
            this.prio.addFirst(rc);
        }
        return rc;
    }

    class URLHistoryPrio {
        private LinkedList buf = new LinkedList();
        private int bufsize = 0;

        private URLHistoryPrio(int size) {
            this.bufsize = size;
        }

        private void addFirst(String url) {
            LinkedList linkedList = this.buf;
            synchronized (linkedList) {
                int idx = this.indexOf(url);
                if (idx >= 0) {
                    this.buf.remove(url);
                } else if (this.buf.size() >= this.bufsize) {
                    this.buf.removeLast();
                }
                this.buf.addLast(url);
            }
        }

        private int indexOf(String url) {
            return this.buf.indexOf(url);
        }
    }
}

