/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: KoikeConfig.java,v 1.3 2005/11/06 14:46:25 rampil Exp $
 */
package org.logical_paradox.koike.core;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;

import org.logical_paradox.koike.core.search.SearchEngine;

/**
 * RtBO[V
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.3 $
 */
public class KoikeConfig {
	/** ftHg̃CfNTXbh */
	public static final int DEFAULT_INDEXER_THREADS = 3;
	/** ftHgn-gram */
	public static final int DEFAULT_N_GRAM_TERM_LENGTH = 2;

	/** }X^[̃vpeB */
	private Properties masterProperty;
	/** T[`GW */
	private SearchEngine searchEngine;
	/** ۃC^[tF[Xt@Ng */
	private ConcreteInterfaceFactory interfaceFactory;
	/** ۃC^[tF[Xt@Ng̏p[^ */
	private String initialParameter;
	/** ͑҂L[ɂȂۂɃCfNT~邩ǂ */
	private boolean waitOnEmpty = false;
	/** CfNT̃Xbh */
	private int indexerThreads = DEFAULT_INDEXER_THREADS;
	/** N-gram */
	private int ngramTermLength = DEFAULT_N_GRAM_TERM_LENGTH;

	/**
	 * RXgN^
	 * @param prop vpeB
	 */
	public KoikeConfig(Properties prop) throws KoikeConfigException {
		marshall(prop);
	}
	/**
	 * w肳ꂽvpeBt@CɂāC̃CX^X̃vpeBݒ肷
	 * @param prop vpeBt@C
	 */
	protected void marshall(Properties prop) throws KoikeConfigException {
		masterProperty = prop;
		try {
			// INTERFACE_FACTORY
			String factoryName = prop.getProperty(KoikeConstant.KEY_INTERFACE_FACTORY);
			if(factoryName == null || factoryName.trim().length() == 0) {
				throw new IllegalArgumentException("K{[INTERFACE_FACTORY]܂");
			}
			Constructor constructor = Class.forName(factoryName).getConstructor(new Class[] {String.class});
			// INTERFACE_FACTORY_INITPARAM
			initialParameter = prop.getProperty(KoikeConstant.KEY_INTERFACE_FACTORY_INITPARAM);
			interfaceFactory = (ConcreteInterfaceFactory)constructor.newInstance(new String[] {initialParameter});

			// N_GRAM_TERM_LENGTH
			String ngramTermLengthStr = prop.getProperty(KoikeConstant.KEY_N_GRAM_TERM_LENGTH);
			if(ngramTermLengthStr == null || ngramTermLengthStr.trim().length() == 0) {
				ngramTermLength = DEFAULT_N_GRAM_TERM_LENGTH;
			} else {
				ngramTermLength = Integer.parseInt(ngramTermLengthStr);
			}
			// INDEXER_THREADS
			String threadCountStr = prop.getProperty(KoikeConstant.KEY_INDEXER_THREADS);
			if(threadCountStr != null && threadCountStr.trim().length() > 0) {
				indexerThreads = Integer.parseInt(threadCountStr);
			} else {
				indexerThreads = DEFAULT_INDEXER_THREADS;
			}
		
		} catch(Exception e) {
			throw new KoikeConfigException(e);
		}
	}
	/**
	 * CfNTXbhԂ
	 * @return CfNTXbh
	 */
	public int getIndexerThreads() {
		return indexerThreads;
	}

	/**
	 * ۃC^[tF[Xt@Ngp̏p[^Ԃ
	 * @return p[^
	 */
	public String getInitialParameter() {
		return initialParameter;
	}

	/**
	 * ۃC^[tF[Xt@NgԂ
	 * @return ۃC^[tF[Xt@Ng
	 */
	public ConcreteInterfaceFactory getInterfaceFactory() {
		return interfaceFactory;
	}

	/**
	 * N-gramԂ
	 * @return N-gram
	 */
	public int getNgramTermLength() {
		return ngramTermLength;
	}

	/**
	 * T[`GWԂ
	 * @return T[`GW
	 */
	public SearchEngine getSearchEngine() throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
		if(searchEngine == null) {
			// T[`GW܂[hĂȂꍇC[h
			String searchEngineClass = masterProperty.getProperty(KoikeConstant.KEY_SEARCH_ENGINE_CLASS);
			if(searchEngineClass != null && searchEngineClass.trim().length() > 0) {
				Class clazz = Class.forName(searchEngineClass);
				Constructor cstr = clazz.getConstructor(new Class[]{KoikeConfig.class});
				searchEngine = (SearchEngine)cstr.newInstance(new Object[]{this});
			}
		}
		return searchEngine;
	}

	/**
	 * L[ɉȂȂۂɁAI邩ǂԂ
	 * @return true:VhLg҂ / false:I
	 */
	public boolean isWaitOnEmpty() {
		return waitOnEmpty;
	}
}
