/*
 * $Id: Indexer.java,v 1.3 2005/05/31 14:38:19 rampil Exp $
 * Copyright (c) 2004 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.koike.core.indexer;

import java.io.FileInputStream;
import java.util.Properties;

import org.logical_paradox.koike.core.KoikeConfig;
import org.logical_paradox.koike.core.KoikeConstant;
import org.logical_paradox.koike.core.logging.LogFactory;
import org.logical_paradox.koike.core.logging.Logger;

/**
 * CfNT
 * 
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.3 $
 */
public class Indexer {
	// K[
	private Logger log = LogFactory.getLogger();

	// RtBO[V
	private KoikeConfig config;
	// CfNTXbh
	private IndexerThread[] indexers;

	/**
	 * RXgN^
	 */
	public Indexer() {
	}
	/**
	 * RtBOt@C[h
	 * @param filename t@C
	 * @throws IOException [hɎs
	 */
	public void loadConfig(String filename) throws Exception {
		log.write("**** RtBOt@C[hĂ܂ ****");

		Properties prop = new Properties();
		prop.load(new FileInputStream(filename));

		// RtBO[V̐
		config = new KoikeConfig(prop);
	}
	/**
	 * CfNTJn
	 * @throws Exception
	 */
	public void begin() throws Exception {
		log.write("**** CfNTJnĂ܂ ****");
		int threadCount = config.getIndexerThreads();

		log.write("**** CfNT" + threadCount + "܂ ****");

		// Xbh̍쐬ƊJn
		indexers = new IndexerThread[threadCount];
		for(int i = 0; i < threadCount; i++) {
			indexers[i] = new IndexerThread(config);
			indexers[i].start();
		}
		for(int i = 0; i < threadCount; i++) {
			indexers[i].join();
		}
		log.write("**** CfNTI܂ ****");
	}
	/**
	 * C\bh
	 * 
	 * @param args vO
	 * @throws Exception sɔO
	 */
	public static void main(String[] args) throws Exception {
		Indexer indexer = new Indexer();
		String configfilename = null;
		if(args.length == 0) {
			configfilename = KoikeConstant.DEFAULT_CONFIG_FILEPATH;
		} else {
			configfilename = args[0];
		}

		indexer.loadConfig(configfilename);

		indexer.begin();
	}
}
