/*
 * $Id: IndexerThread.java,v 1.5 2005/05/31 14:38:19 rampil Exp $
 * Copyright (c) 2004 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.koike.core.indexer;

import java.util.Iterator;

import org.logical_paradox.koike.core.KoikeConfig;
import org.logical_paradox.koike.core.document.DocumentAccessor;
import org.logical_paradox.koike.core.logging.LogFactory;
import org.logical_paradox.koike.core.logging.Logger;
import org.logical_paradox.koike.core.parser.Parser;
import org.logical_paradox.koike.core.parser.Term;

/**
 * CfNTXbh
 * 
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.5 $
 */
public class IndexerThread extends Thread {
	/** CfbNXVXeɐڑĂC^[tF[X */
	private IndexAccessor idxAccessor;
	/** RecǗVXeɐڑĂC^[tF[X */
	private DocumentAccessor docAccessor;
	/** [gL[VXeɐڑĂC^[tF[X */
	private Iterator ri;
	/** RtBO[V */
	private final KoikeConfig config;

	// K[
	private Logger log = LogFactory.getLogger();

	// p[U[
	private final Parser parser;

	/**
	 * RXgN^
	 * @param cfg RtBO
	 */
	public IndexerThread(KoikeConfig cfg) throws Exception {
		config = cfg;

		// CfbNXT[o[p̐ڑC^[tF[X
		idxAccessor = config.getInterfaceFactory().getIndexAccessor();
		// RecǗVXe̐ڑC^[tF[X
		docAccessor = config.getInterfaceFactory().getDocumentAccessor();
		// [gL[VXeɐڑĂCe[^
		ri = config.getInterfaceFactory().getRemoteQueueIterator();

		// n-gramp[U[
		parser = new Parser(config.getNgramTermLength());
	}

	/**
	 * XbhC
	 */
	public void run() {
		log.write("**** Xbh[" + this.toString() + "]CfNVOJn܂");

		// L[ɏׂReccĂԌp
		// L[ɉcĂԂ͏block
		boolean loopc = true;
		try {
			while(loopc) {
				String digest = null;
				while((digest = getDigest()) != null) {
					String contents = null;
					try {
						log.write("_CWFXg[" + digest + "]͂Ă܂");
						// 擾ł_CWFXgŃRect@C_[ғ
						contents = docAccessor.getDocument(digest).getDocument();
						// p[X
						Term[] terms = parser.parse(contents);
						// CfbNXT[o[ւ̓o^(Ƃ̂Ƃ͂܂)
						transfer(digest, terms);
					} catch (Exception e) {
						e.printStackTrace();
						log.write("_CWFXg[" + digest + "]RecǗVXeɂ܂");
					}
				}

				if(config.isWaitOnEmpty() == false) {
					log.write("waitonemptytOtruê߁ACfNVOI܂");
					loopc = false;
					continue;
				}
				// X[v
				Thread.sleep(2000);
			}
		} catch(InterruptedException ie) {
			tearDown();
		}
		log.write("**** Xbh[" + this.toString() + "]CfNVOI܂");
	}
	/**
	 * L[VXe_CWFXgoĕԂ
	 * Iterator.hasNext()next()ɑ΂synchronizedKp邽߂ɍ\bh
	 * @return
	 */
	protected String getDigest() {
		synchronized(ri) {
			if(ri.hasNext() == false) {
				return null;
			} else {
				return (String)ri.next();
			}
		}
	}
	/**
	 * CfbNXT[o[ɑ΂āCƈʒux܂Ƃ߂đMD
	 * Pʂœ]邩́C̃\bhɂ䂾˂
	 * @param digest hLg̃_CWFXg
	 * @param terms ]Ȃ΂ȂȂ
	 * @throws Exception ]ɔO
	 */
	protected void transfer(String digest, Term[] terms) throws Exception {
		// Ƃ肠S܂Ƃ߂ĂƂ
		idxAccessor.addTerm(digest, terms);
	}
	/**
	 * Xbh̒~
	 */
	protected void tearDown() {
		log.write("**** Xbh~܂ ****");
		// CfbNXVXeƂ̐ڑC^[tF[XN[Y
		try {
			synchronized(idxAccessor) {
				if(idxAccessor != null && idxAccessor.isClosed() == false) {
					idxAccessor.close();
					idxAccessor = null;
				}
			}
		} catch(IndexAccessException e) {
			log.write("**** CfbNXVXeƂ̐ڑC^[tF[X̃N[YɎs܂");
		}
		// hLg\[X̐ڑC^[tF[XN[Y
		try {
			synchronized(docAccessor) {
				if(docAccessor != null && docAccessor.isClosed() == false) {
					docAccessor.close();
					docAccessor = null;
				}
			}
		} catch(Exception e) {
			log.write("**** hLg\[X̐ڑC^[tF[X̃N[YɎs܂");
		}
		log.write("**** Xbh~܂ ****");
	}
}
