/*
 * $Id: InvertedIndexKey.java,v 1.3 2005/05/31 14:38:19 rampil Exp $
 * Copyright (c) 2004 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.koike.core.indexer;

/**
 * ]uCfbNX1R[h\L[NX
 * 
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.3 $
 */
public class InvertedIndexKey {
	public static final int SUPPORTED_DOCUMENTS = 64;	// ̍L[ŃT|[gł镶
	private final String key;
	protected long document;								// ꂪǂ̕Ɋ܂܂Ă邩D
															// MSB = ԍ1 LSB = ԍ64
															// erbgƁC1ōꂠC0ōȂ

	/**
	 * RXgN^
	 */
	public InvertedIndexKey(String k) {
		this(k,0);
	}
	/**
	 * RXgN^
	 * @param k L[
	 * @param documents ܏
	 */
	public InvertedIndexKey(String k, long documents) {
		key = k;
		document = documents;
	}
	/**
	 * ܏Ԃ
	 * @return ܏
	 */
	public long getDocument() {
		return document;
	}

	/*
	 * w肳ꂽԍɍꂪ܂܂Ă̂Ƃ
	 */
	public void setIndexTermOnDocument( int documentNo, boolean stat ) throws IllegalArgumentException {
		if( documentNo < 0 || documentNo > 63 ) {
			throw new IllegalArgumentException( "w肳ꂽԍ͖ł" );
		}

		long rad = 1;
		rad <<= (63-documentNo);

		if( stat ) {
			document |= rad;			// rbgZbgꍇ
		} else {
			rad = rad ^ (-1);
			document &= rad;			// rbgZbgꍇ
		}

		//System.err.println( "rad=" + get64bitFormat(rad) );
	}

	public boolean isTermFoundInDocument( int documentNo ) throws IllegalArgumentException {
		if( documentNo < 0 || documentNo > 63 ) {
			throw new IllegalArgumentException( "w肳ꂽԍ͖ł" );
		}

		long rad = 1;
		rad <<= (63-documentNo);

//System.err.println( get64bitFormat( document & rad ) );
		if( (document & rad) != 0 ) {
			return true;
		} else {
			return false;
		}
	}

	public String get64bitFormat( long l ) {
		String bit64String = "0000000000000000000000000000000000000000000000000000000000000000" + Long.toBinaryString( l );
		return bit64String.substring( bit64String.length() - 64, bit64String.length() );
	}

	public static void main( String args[] ) {
		InvertedIndexKey r = new InvertedIndexKey( "L[" );
		r.setIndexTermOnDocument( 0, true );
		r.setIndexTermOnDocument( 1, true );
		r.setIndexTermOnDocument( 2, true );
		r.setIndexTermOnDocument( 3, true );
		System.err.println( r.toString() );
	}
}

// end of InvertedIndexKey.java
