/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: InvertedIndex.java,v 1.3 2005/12/04 06:09:33 rampil Exp $
 */
package org.logical_paradox.koike.core.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.logical_paradox.koike.core.KoikeConstant;

/**
 * ]uCfbNX
 * {000110000..Ȃǂ̋0,1ō̑ݏ\<br>
 * 21documents\̂21bitKvȂ̂ŁA64bit(long)̃ubN<br>
 * zƂĕ\ĂBKv̂ȂɂĂ͊i[ȂƂ<br>
 * eʂߖ񂵂ĂB
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.3 $
 */
public class InvertedIndex {
	/** m[hID */
	private final String nodeId;
	/** ubNԍ */
	private final int blockno;
	/** ]uCfbNX */
	private long documents;
	/** P[V}bv(L[:docno l:ʒu̔z) */
	private HashMap locationMap = new HashMap();

	/**
	 * RXgN^
	 * @param nodeId_ m[hID
	 * @param blockno_ ubNԍ
	 * @param documents_ ]uCfbNX(ebit 0: 1:Ȃ), MSB=ő LSB=ŏ
	 */
	public InvertedIndex(String nodeId_, int blockno_, long documents_) {
		nodeId = nodeId_;
		blockno = blockno_;
		documents = documents_;
	}
	/**
	 * Rs[RXgN^
	 * @param iidx ̃f[^
	 */
	public InvertedIndex(InvertedIndex iidx) {
		nodeId = new String(iidx.getNodeId());
		blockno = iidx.getBlockNo();
		documents = iidx.getDocumentAvailability();
		locationMap = (HashMap)iidx.locationMap.clone();
	}
	/**
	 * m[hIDԂ
	 * @return
	 */
	public String getNodeId() {
		return nodeId;
	}
	/**
	 * ̓]uCfbNX̃ubNԍԂ
	 * @return ubNԍ
	 */
	public int getBlockNo() {
		return blockno;
	}
	/**
	 * Ym[h/YubN̕]uCfbNXݒ肷
	 * ݒlɏ]āAʒu폜(ꍇ̂)
	 * @param doc ]uCfbNX
	 */
	public void setDocumentAvailability(long doc) {
		setDocumentAvailability(doc, true);
	}
	/**
	 * Ym[h/YubN̕]uCfbNXݒ肷
	 * @param doc ]uCfbNX
	 * @param filter true:ʒutB^ / false:Ȃ
	 */
	public void setDocumentAvailability(long doc, boolean filter) {
		if(filter == true) {
			filterLocations(doc);
		}
		documents = doc;
	}
	/**
	 * Ym[h/YubN̕]uCfbNXԂ
	 * @return ]uCfbNX
	 */
	public long getDocumentAvailability() {
		return documents;
	}
	/**
	 * ǂr
	 * m[hID/ubNԍvĂOkƂ
	 */
	public boolean equals(Object o) {
		if(o == null || o instanceof InvertedIndex == false) {
			return false;
		}
		InvertedIndex iidx = (InvertedIndex)o;

		return iidx.blockno == blockno && iidx.nodeId.equals(nodeId);
	}
	/**
	 * nbVR[hԂ
	 * m[hIDƃubNԍvĂ΁AlԂ
	 * @return nbVR[h
	 */
	public int hashCode() {
		return nodeId.hashCode() * blockno + (blockno/2);
	}
	/**
	 * ʒuǉ
	 * @param location ʒu
	 */
	public void addLocation(Location location) {
		synchronized(locationMap) {
			Integer docno = new Integer(location.getDocno());
			ArrayList locations = (ArrayList)locationMap.get(docno);
			if(locations == null) {
				locations = new ArrayList();
			}
			locations.add(location);
			locationMap.put(docno, locations);
		}
	}
	/**
	 * ʒuj
	 * @param location ʒu
	 */
	public void removeLocation(Location location) {
		synchronized(locationMap) {
			int docno = location.getDocno();
			Integer docnoKey = new Integer(docno);
			ArrayList locations = (ArrayList)locationMap.get(docnoKey);
			if(locations == null) {
				return;
			}
			// ʒu̔j
			locations.remove(location);

			if(locations.size() == 0) {
				// w蕶̈ʒu񂪑SȂȂĂ܂ꍇC]uĐݒ肷
				long filter = ~(1 << (docno - (blockno * KoikeConstant.INVERTED_INDEX_BLK_SIZE)));
				documents = documents & filter;
				locationMap.remove(docnoKey);
			} else {
				locationMap.put(docnoKey, locations);
			}
		}
	}
	/**
	 * ʒuԂ
	 * @param docno ԍ
	 * @param offset 擪̃ItZbg
	 * @return ʒu(null:Ȃ)
	 */
	public Location getLocation(int docno, int offset) {
		synchronized(locationMap) {
			ArrayList locations = (ArrayList)locationMap.get(new Integer(docno));
			if(locations == null || locations.size() == 0) {
				return null;
			}
			Location key = new Location(nodeId, docno, offset);
			int index = locations.indexOf(key);
			if(index < 0) {
				return null;
			} else {
				return(Location)locations.get(index);
			}
		}
	}
	/**
	 * ʒuĂ邩ǂԂ
	 * @return true:Ă / false:ĂȂ
	 */
	public boolean hasLocations() {
		return locationMap.size() > 0;
	}
	/**
	 * whLg̈ʒuĂ邩ǂԂ
	 * @param docno ԍ
	 * @return true:Ă / false:ĂȂ
	 */
	public boolean hasLocationsOf(int docno) {
		ArrayList locations = (ArrayList)locationMap.get(new Integer(docno));
		return locations != null && locations.size() > 0;
	}
	/**
	 * ʒũCe[^Ԃ
	 * @return ʒũCe[^
	 */
	public Iterator iteratorLocations() {
		return new LocationIterator(locationMap);
	}
	/**
	 * w肳ꂽ]uʒuɏ]āCKvȂȂʒu𓖊YCfbNX珜
	 * ubNԍm[hIDȂǂ͕ύXȂƂ̑O
	 * @param documents ]uʒu
	 */
	protected void filterLocations(long documents) {
		long filter = 1;
		int docno = blockno * KoikeConstant.INVERTED_INDEX_BLK_SIZE;

		// ǂbitĂ邩
		for(int i = 0; i < KoikeConstant.INVERTED_INDEX_BLK_SIZE; i++, filter <<= 1, docno++) {
			if((documents & filter) == 0) {
				// Yɍꂪ݂Ȃ̂ŁAʒu
				synchronized(locationMap) {
					Integer key = new Integer(docno);
					ArrayList locations = (ArrayList)locationMap.get(key);
					if(locations != null) {
						// S
						locations.clear();
						locationMap.remove(key);
					}
				}
			}
		}
	}
	/**
	 * CX^XRs[
	 */
	protected Object clone() throws CloneNotSupportedException {
		return new InvertedIndex(this);
	}

	/**
	 * ʒuԂCe[^
	 * @author satoshi akabane@logical-paradox.org
	 * @version $Revision: 1.3 $
	 */
	class LocationIterator implements Iterator {
		/** ʒũXg */
		private final ArrayList values = new ArrayList();
		/** ʒu񃊃Xg̃Ce[^ */
		private final Iterator listIterator;

		/**
		 * RXgN^
		 * @param m ʒũ}bv
		 */
		protected LocationIterator(Map m) {
			synchronized(m) {
				// w肳ꂽ}bvɊi[ĂSĂ̒l𒊏o
				for(Iterator it = m.values().iterator(); it.hasNext();) {
					List locations = (List)it.next();
					if(locations != null) {
						values.addAll(locations);
					}
				}
			}
			listIterator = values.iterator();
		}
		/**
		 * RNVl폜
		 */
		public void remove() {
			listIterator.remove();
		}
		/**
		 * ̒l݂邩ǂԂ
		 * @return true: / false:Ȃ
		 */
		public boolean hasNext() {
			return listIterator.hasNext();
		}
		/**
		 * Ce[^QƂĂ鎟̗vfԂ
		 * @return ̗vf
		 */
		public Object next() {
			return listIterator.next();
		}
	}
}
