/*
 * $Id: KoikeIndexResultSet.java,v 1.3 2005/12/04 06:09:33 rampil Exp $
 * Copyright (c) 2004 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.koike.core.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

import org.logical_paradox.koike.core.KoikeConstant;

/**
 * CfbNXT[o[ɖ₢킹ʂێIuWFNg
 * (邢͌)݂ʒuW񂵂Ċi[B<br>
 * ꂲƂɕʁX̃CX^Xɂĕ\B
 * @author  satoshi akabane@logical-paradox.org
 * @version $Revision: 1.3 $
 */
public class KoikeIndexResultSet {
	/** ]uCfbNX̃Xg(ʒu) */
	private ArrayList invertedIndexes = new ArrayList();
	
	/**
	 * RXgN^
	 */
	public KoikeIndexResultSet() {
	}
	/**
	 * w肳ꂽʒuɍꂪzuĂ邩ǂ𒲂ׂ
	 * @param nodeId m[hID
	 * @param docno ԍ
	 * @param offset 擪̃ItZbg
	 * @return true: / false:Ȃ
	 */
	public boolean isLocated(String nodeId, int docno, int offset) {
		// w肳ꂽubN̓]uCfbNX擾
		int blkno = docno / KoikeConstant.INVERTED_INDEX_BLK_SIZE;
		InvertedIndex iidx = getInvertedIndex(nodeId, blkno);

		if(iidx == null) {
			// ]uCfbNX̂̂Ȃ
			return false;
		}
		// ]uCfbNX񂩂Awʒȕ擾Ă݂
		Location found = iidx.getLocation(docno, offset);
		if(found == null) {
			return false;
		} else {
			return true;
		}
	}
	/**
	 * ]uCfbNXʃZbgɑ΂ĒǉD
	 * ɓʒu񂪑݂ꍇC폜ĂǉD
	 * @param iidx ]uCfbNX
	 */
	public void addInvertedIndex(InvertedIndex iidx) {
		synchronized(invertedIndexes) {
			// ɓʒu񂪑݂ꍇA폜Ăǉ(do^h~)
			invertedIndexes.remove(iidx);
			invertedIndexes.add(iidx);
		}
	}
	/**
	 * ]uCfbNXʃZbgɑ΂ĒǉD
	 * @param list ]uCfbNX̃Xg
	 */
	public void addInvertedIndexes(List list) {
		invertedIndexes.addAll(list);
	}
	/**
	 * ̌ʃZbg̈ʒu񂪋󂩂ǂԂ
	 * @return true: / false:Ă
	 */
	public boolean isEmpty() {
		return invertedIndexes.size() == 0;
	}
	/**
	 * ]uCfbNẌʒu
	 */
	public void clear() {
		invertedIndexes.clear();
	}
	/**
	 * ]uCfbNXԂ(݂)
	 * @param nodeId m[hID
	 * @param blkno ubNԍ
	 * @return ]uCfbNX(null:݂)
	 */
	public InvertedIndex getInvertedIndex(String nodeId, int blkno) {
		return getInvertedIndex(new InvertedIndex(nodeId, blkno, 0L));	
	}
	/**
	 * ]uCfbNXԂ(݂)
	 * ]uCfbNXœ]uCfbNXĂ邪AInvertedIndexequals()<br>
	 * nodeidblknȏgݍ킹true/false𔻒肵Ă邽߁AƂė^ꂽ]uCfbNX<br>
	 * ʃZbgƂĊi[Ă]uCfbNXdocumentslႤꍇ邽
	 * @param ]uCfbNX
	 * @return ]uCfbNX(null:݂)
	 */
	public InvertedIndex getInvertedIndex(InvertedIndex iidx) {
		synchronized(invertedIndexes) {
			int index = invertedIndexes.indexOf(iidx);
			if(index < 0) {
				return null;
			}
			return (InvertedIndex)invertedIndexes.get(index);
		}
	}
	/**
	 * w肳ꂽ̂Ɠm[hID,blkno]uCfbNXXg珜
	 */
	public void removeInvertedIndex(InvertedIndex iidx) {
		invertedIndexes.remove(iidx);
	}
	/**
	 * ]uCfbNX̃Ce[^Ԃ
	 * @return ]uCfbNX̃Ce[^
	 */
	public Iterator iteratorInvertedIndexes() {
		return invertedIndexes.iterator();
	}
	/**
	 * ]uCfbNX̃XgԂD
	 * CύXłȂD
	 * @return ]uCfbNX̃Xg
	 */
	public List getInvertedIndexes() {
		return Collections.unmodifiableList(invertedIndexes);
	}
	/**
	 * ̃CX^XRs[
	 */
	public Object clone() throws CloneNotSupportedException {
		KoikeIndexResultSet result = new KoikeIndexResultSet();
		result.invertedIndexes = (ArrayList)invertedIndexes.clone();

		return result;
	}

}
