/*
 * $Id: SearchEngine.java,v 1.5 2005/11/06 14:46:25 rampil Exp $
 * Copyright (c) 2004 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.koike.core.search;

import org.logical_paradox.koike.core.KoikeConfig;
import org.logical_paradox.koike.core.document.DocumentAccessor;
import org.logical_paradox.koike.core.indexer.IndexAccessor;
import org.logical_paradox.koike.core.parser.Parser;

/**
 * GW̊NX
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.5 $
 */
public abstract class SearchEngine {
	/** RtBO[V */
	private KoikeConfig config;
	/** CfbNXANZT */
	private IndexAccessor indexAccessor;
	/** hLgANZT */
	private DocumentAccessor documentAccessor;
	/** p[U[ */
	private Parser parser;

	/**
	 * RXgN^D
	 * @param cfg RtBO[V
	 * @throws Exception CX^X̐ɔO
	 */
	protected SearchEngine(KoikeConfig cfg) throws Exception {
		config = cfg;
		init();
	}
	/**
	 * T[`GW̋ʏR[h
	 * ʂɎꍇÃ\bhTuNXŃI[o[Ch邱
	 * @throws Exception ɔO
	 */
	protected void init() throws Exception {
	}
	/**
	 * RtBO[VԂ
	 * @return RtBO[V
	 */
	protected KoikeConfig getConfig() {
		return config;
	}
	/**
	 * s
	 * ̂̓TuNX
	 * @param condition 
	 * @return ʃZbg
	 * @throws SearchException ɔQ
	 */
	public abstract SearchResult search(SearchCondition condition) throws SearchException;

	/**
	 * IĂp[U[Ԃ
	 * @return p[U[
	 */
	protected synchronized Parser getParser() {
		if(parser == null) {
			parser = new Parser(config.getNgramTermLength());
		}
		return parser;
	}
	/**
	 * CfbNXVXeɑ΂ANZXC^[tF[XԂ
	 * C^[tF[X܂ĂȂꍇAĕԂ<br>
	 * 1xłꂽꍇA2xڈȍ~̌ďoł͏ȂB
	 * @return CfbNXVXeɐڑ邽߂̃C^[tF[X
	 * @throws SearchException Ɏs
	 */
	protected synchronized IndexAccessor getIndexAccessor() throws SearchException {
		if(indexAccessor == null) {
			try {
				indexAccessor = getConfig().getInterfaceFactory().getIndexAccessor();
			} catch (Exception e) {
				e.printStackTrace();
				throw new SearchException(e);
			}
		}
		return indexAccessor;
	}
	/**
	 * hLgǗVXeɑ΂ANZXC^[tF[XԂ
	 * C^[tF[X܂ĂȂꍇAĕԂ<br>
	 * 1xłꂽꍇA2xڈȍ~̌ďoł͏ȂB
	 * @return hLgǗVXeɐڑ邽߂̃C^[tF[X
	 * @throws SearchException Ɏs
	 */
	protected synchronized DocumentAccessor getDocumentAccessor() throws SearchException {
		if(documentAccessor == null) {
			try {
				documentAccessor = getConfig().getInterfaceFactory().getDocumentAccessor();
			} catch (Exception e) {
				e.printStackTrace();
				throw new SearchException(e);
			}
		}
		return documentAccessor;
	}
}
