/*
 * $Id: DefaultSummaryGenerator.java,v 1.2 2005/05/31 14:38:20 rampil Exp $
 * Copyright (c) 2004 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.koike.core.summary;

import java.util.ArrayList;
import java.util.Collections;
import org.logical_paradox.common.util.StringUtils;

/**
 * WIȃT}[WFl[^<br>
 * <br>
 * ȉ̏ŁA͈͂肷<br>
 * <li>̎</li>
 * <li>̋</li>
 * <li>̐</li>
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.2 $
 */
public class DefaultSummaryGenerator implements SummaryGenerator {
	/** ftHg̃T}[ */
	public static final int DEFAULT_SUMMARY_LENGTH = 100;
	/** T}[ */
	private final int summaryLength;

	/**
	 * RXgN^
	 */
	public DefaultSummaryGenerator() {
		summaryLength = DEFAULT_SUMMARY_LENGTH;
	}
	/**
	 * RXgN^
	 * UTŎgp邽߂̂
	 * @param summaryLength_ v̒
	 */
	public DefaultSummaryGenerator(int summaryLength_) {
		summaryLength = summaryLength_;
	}
	/**
	 * T}[𐶐
	 * @param document ̕
	 * @param terms ƂĎw肳ꂽL[[h
	 * @return ꂽT}[
	 */
	public String createSummary(String document, String[] terms) {
		// ꂲƂ̏oʒu
		Integer[] locations = null;
		// SĂ̌̏oʒu
		ArrayList summaryStartPoints = new ArrayList();

		// SĂ̌̏oʒu
		for(int i = 0; i < terms.length; i++) {
			locations = StringUtils.searchWordIndexes(document, terms[i]);
			for(int j = 0; j < locations.length; j++) {
				summaryStartPoints.add(new Location(i, terms[i], locations[j].intValue()));
			}
		}
		// w肳ꂽꂪw肳ꂽ񒆂ɑ݂Ȃꍇ̓uNԂ
		if(summaryStartPoints.size() == 0) {
			return "";
		}
		// ʒũ\[g()
		Collections.sort(summaryStartPoints);

		// vƂčœKȈʒuv
		Location[] summaryStartPoint = (Location[])summaryStartPoints.toArray(new Location[0]);
		ArrayList evals = new ArrayList();
		String candidate = null;
		for(int i = 0; i < summaryStartPoint.length; i++) {
			candidate = document.substring(summaryStartPoint[i].pos);
			if(candidate.length() > summaryLength) {
				// őT}[蒷񂪎ꂽꍇArŃJbg
				candidate = candidate.substring(0, summaryLength);
			} else if(candidate.length() < summaryLength) {
				// w肳ꂽT}[ZꍇAKv⊮
				int pos = document.length() - summaryLength;
				if(pos < 0) {
					pos = 0;
				}
				candidate = document.substring(pos);
			}
			// ]|Cgv
			evals.add(eval(candidate, summaryStartPoint[i].pos, terms));
		}

		// ]|Cg]̍Ƀ\[gāCԍŏɂ̂v
		Collections.sort(evals);
		EvaluationPoint best = (EvaluationPoint)evals.get(0);

		StringBuffer sb = new StringBuffer();
		String summary = best.getSummary();
		if(document.startsWith(summary) == false) {
			sb.append("..");
		}
		sb.append(summary);
		if(document.endsWith(summary) == false) {
			sb.append("..");
		}
		
		return sb.toString();
	}
	/**
	 * w肳ꂽT}[̕]|Cgv
	 * @param summary T}[
	 * @param pos ʒu
	 * @param locations ̈ʒu(oʒuŃ\[gĂ)
	 * @return ]|Cg
	 */
	protected EvaluationPoint eval(String summary, int pos, String[] terms) {
		int occupied = 0;
		int variation = 0;
		String remain = summary;

		// v͈͓̔Ɋ܂܂ꐔv
		for(int i = 0; i < terms.length; i++) {
			occupied += StringUtils.searchWordIndexes(summary, terms[i]).length * terms[i].length();
			String replaced = remain.replaceAll(terms[i], "");
			if(replaced.length() < remain.length()) {
				variation++;
			}
		}
		int distance = occupied * 100 / summary.length();

		return new EvaluationPoint(summary, pos, distance, variation * 100 / terms.length);
	}
	/**
	 * ̏oʒu\ʒuNX
	 * @author satoshi akabane@logical-paradox.org
	 * @version $Revision: 1.2 $
	 */
	class Location implements Comparable {
		/** ޔԍ */
		final int index;
		/**  */
		final String term;
		/** oʒu */
		final int pos;

		/**
		 * RXgN^
		 * @param term_ 
		 * @param pos_ ʒu
		 */
		public Location(int index_, String term_, int pos_) {
			index = index_;
			term = term_;
			pos = pos_;
		}
		/**
		 * r
		 * ʒuɃ\[g邽
		 * @param o rΏ
		 * @return 0: 1:傫 -1:
		 */
		public int compareTo(Object o) {
			Location l = (Location)o;
			if(l.pos == pos) {
				return 0;
			} else if(pos < l.pos) {
				return -1;
			} else {
				return 1;
			}
		}
	}
	/**
	 * v̊JnʒuXRA
	 * @author satoshi akabane@logical-paradox.org
	 * @version $Revision: 1.2 $
	 */
	class EvaluationPoint implements Comparable {
		/** T}[ */
		private String summary;
		/** ʒu */
		private int pos;
		/** Ɖ񐔂̃XRA */
		private int distance;
		/** ̏ooG[ṼXRA */
		private int variation;

		/** vJnʒuƂẴXRA */
		private int locationScore;

		/**
		 * RXgN^
		 * @param pos_ vJnʒu
		 * @param distance_ ƐɂXRA
		 * @param variation_ lɂXRA
		 */
		public EvaluationPoint(String summary_, int pos_, int distance_, int variation_) {
			summary = summary_;
			pos = pos_;
			distance = distance_;
			variation = variation_;
			
			computeTotalScore();
		}
		/**
		 * T}[Ԃ
		 * @return T}[
		 */
		public String getSummary() {
			return summary;
		}
		/**
		 * vJnʒuƂẴXRAvZ
		 */
		protected void computeTotalScore() {
			locationScore = (int)distance + variation * 9;
		}
		/**
		 * r
		 * @param o rΏ
		 * @return 0: 1:傫 -1:
		 */
		public int compareTo(Object o) {
			EvaluationPoint e = (EvaluationPoint)o;
			if(e.getLocationScore() == getLocationScore()) {
				return 0;
			} else if(e.getLocationScore() > getLocationScore()) {
				return 1;
			} else {
				return -1;
			}
		}
		/**
		 * vJnʒuƂẴXRAԂ
		 * @return vJnʒuƂẴXRA
		 */
		public int getLocationScore() {
			return locationScore;
		}
		/**
		 * vJnʒuԂ
		 * @return vJnʒu
		 */
		public int getPos() {
			return pos;
		}
		/**
		 * Ԃ̋ƐɂXRAԂ
		 * @return@Ԃ̋Ɛ̃XRA
		 */
		public int getDistanceScore() {
			return distance;
		}
		/**
		 * ̏oސɂXRAԂ
		 * @return ̏oސɂXRA
		 */
		public int getVariationScore() {
			return variation;
		}
	}
}
