/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: RSSSearchEngine.java,v 1.9 2005/11/26 17:08:01 rampil Exp $
 */
package org.logical_paradox.koike.rss.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

import org.logical_paradox.common.util.StringUtils;
import org.logical_paradox.koike.core.KoikeConfig;
import org.logical_paradox.koike.core.KoikeConstant;
import org.logical_paradox.koike.core.document.Document;
import org.logical_paradox.koike.core.indexer.IndexAccessException;
import org.logical_paradox.koike.core.indexer.IndexNotFoundException;
import org.logical_paradox.koike.core.parser.ParserException;
import org.logical_paradox.koike.core.search.Element;
import org.logical_paradox.koike.core.search.InvertedIndex;
import org.logical_paradox.koike.core.search.KoikeIndexResultSet;
import org.logical_paradox.koike.core.search.ResultSet;
import org.logical_paradox.koike.core.search.SearchCondition;
import org.logical_paradox.koike.core.search.SearchEngine;
import org.logical_paradox.koike.core.search.SearchException;
import org.logical_paradox.koike.core.search.SearchResult;
import org.logical_paradox.koike.core.summary.DefaultSummaryGenerator;
import org.logical_paradox.koike.core.summary.SummaryGenerator;
import org.logical_paradox.koike.rss.document.ContentsAttribute;
import org.logical_paradox.koike.rss.search.lo.LogicalOperationException;
import org.logical_paradox.koike.rss.search.lo.LogicalOperatorFactory;

/**
 * RSS/1bpSGW
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.9 $
 */
public class RSSSearchEngine extends SearchEngine {
	/** T}[WFl[^ */
	private static final SummaryGenerator summaryGenerator = new DefaultSummaryGenerator();

	/**
	 * RXgN^
	 * @param cfg RtBO[V
	 * @throws Exception CX^X̐ɎsꍇɔO
	 */
	public RSSSearchEngine(KoikeConfig cfg) throws Exception {
		super(cfg);
	}
	/**
	 * s
	 * @param condition 
	 * @return ʃZbg
	 * @throws SearchException ɔQ
	 */
	public SearchResult search(SearchCondition condition) throws SearchException {
		// T
		ArrayList searchwords = new ArrayList();
		KoikeIndexResultSet indexes = retrieve(searchwords, condition);
		if(indexes == null || indexes.isEmpty() == true) {
			// ɍv̂ɂāACfbNXVXeɖ₢킹ʁA
			// 񓚂Ȃꍇnull
			return new SearchResult();
		}

		return fetchResults(indexes, condition, (String[])searchwords.toArray(new String[0]));
	}
	/**
	 * CfbNXVXẻ񓚂ƂɂāAT[`GWƂĂ̌ʂԂ
	 * @param indexes CfbNXVXẻ
	 * @param condition 
	 * @return (1y[W)
	 */
	protected SearchResult fetchResults(KoikeIndexResultSet indexes, SearchCondition condition, String[] searchwords) throws SearchException { 
		int doccnt = 0;
		int hits = 0;
		int skipcnt = condition.getStartp();

		ArrayList results = new ArrayList();

		for(Iterator it = indexes.iteratorInvertedIndexes(); it.hasNext();) {
			InvertedIndex iidx = (InvertedIndex)it.next();
			String nodeId = iidx.getNodeId();
			int blkno = iidx.getBlockNo();
			long documents = iidx.getDocumentAvailability();

			int docno = blkno * KoikeConstant.INVERTED_INDEX_BLK_SIZE;

			// ]uCfbNXɊ܂܂镶v
			while(documents > 0) {
				if((documents & 1) != 0) {
					hits++;
				}
				documents >>>= 1;
			}
			documents = iidx.getDocumentAvailability();
			// SẴrbgmF
			while((doccnt < condition.getDispnum() || condition.getDispnum() == 0) && documents != 0) {
				if((documents & 1) != 0) {
					if(skipcnt > 0) {
						skipcnt--;
					} else {
						doccnt++;
						results.add(createResultSet(nodeId, docno, searchwords));
					}
				}
				documents >>>= 1;
				docno++;
			}
		}

		Comparator c = getComparator();
		if(c != null) {
			// \[g@IɎw肳ĂꍇC̃[Ōʂ\[g
			Collections.sort(results, c);
		}

		// ʂ쐬
		SearchResult sr = new SearchResult();
		sr.setResultSet((ResultSet[])results.toArray(new ResultSet[0]));
		sr.setHits(hits);

		return sr;
	}
	/**
	 * VXeƂĂ̌ʂ𐶐
	 * @param nodeId m[hID
	 * @param docno ԍ
	 * @return 
	 * @throws SearchException	ʂ̐Ɏs
	 */
	protected ResultSet createResultSet(String nodeId, int docno, String[] terms) throws SearchException {
		try {
			// hLgǗVXeɖ₢킹āAhLĝ̂擾
			String digest = "";
			if(StringUtils.isEmpty(nodeId)) {
				digest = "" + docno;
			} else {
				digest = nodeId + ":" + docno;
			}
			Document document = getDocumentAccessor().getDocument(digest);
			// T}[쐬
			String summary = summaryGenerator.createSummary(document.getDocument(), terms);

			ContentsAttribute attribute = (ContentsAttribute)document.getAttribute();

			// ʂ𐶐
			ResultSet rs = new ResultSet();
			rs.setNodeId(nodeId);
			rs.setDocno(docno);
			rs.setDocumentTitle(attribute.getTitle());
			rs.setSiteName(attribute.getSitename());
			rs.setUrl(attribute.getUrl());
			rs.setSummary(summary);

			return rs;
		} catch(SearchException e) {
			throw e;
		} catch(Exception e) {
			throw new SearchException(e);
		}
	}
	/**
	 * wvfɂāCCfbNXČʂ𓾂
	 * wvfɍXɎq̗vfꍇCċAIɏ
	 * @param searchwords oꂽo^郊Xg
	 * @param element vf
	 * @return ʃZbg
	 * @throws SearchException ɔO
	 */
	protected KoikeIndexResultSet retrieve(List searchwords, Element element) throws SearchException {
		if(element.getElementType() == Element.TYPE_TERM) {
			// oꂽo^
			searchwords.add(element.getAttribute());
			// CfbNXVXeɑ΂Ė₢킹
			return executeQuery(element.getAttribute());
		}
		// ܂ŏɁCqvf̑SĂ̌ʂ܂Ƃ߂
		List childElements = element.getChildNodes();
		KoikeIndexResultSet[] childResults = new KoikeIndexResultSet[childElements.size()];

		for(int i = 0; i < childResults.length; i++) {
			childResults[i] = retrieve(searchwords, (Element)childElements.get(i));
			if(childResults[i] == null) {
				return null;
			}
		}

		// qvf̌ʂ󂯎ŁC̗vfŎw肳Ă_ZKp
		try {
			KoikeIndexResultSet[] results = LogicalOperatorFactory.getOperator(element.getElementType()).execute(childResults);
			// ʂ܂Ƃ߂
			// ̏ꍇC1ꂪZʂƂȂ
			return results == null || results.length == 0 ? null : results[0];
		} catch (LogicalOperationException e) {
			throw new SearchException(e);
		}
	}
	/**
	 * CfbNXVXeɑ΂Ė₢킹𓊂
	 * @param keyword 
	 * @return ʃZbg
	 */
	protected KoikeIndexResultSet executeQuery(String keyword) throws SearchException {
		try {
			// ܂Cɕϊ
			// ܂Cn-gramɕ
			String[] terms = getParser().split(keyword);
			KoikeIndexResultSet[] results = new KoikeIndexResultSet[terms.length];
			if(results == null || results.length == 0) {
				return null;
			}
			for(int i = 0; i < terms.length; i++) {
				results[i] = getIndexAccessor().getValue(terms[i]);
				if(results[i] == null) {
					// CfbNXVXeɁAYꂪo^ĂȂ̂ŌʂȂ
					return null;
				}

				if(i > 0) {
					// 1ȊȌꍇC1Ɠ]uCfbNXANDƂ
					KoikeIndexResultSet[] andOperationApplied = LogicalOperatorFactory.getOperator(Element.TYPE_AND).execute(new KoikeIndexResultSet[]{results[0], results[i]});
					if(andOperationApplied == null) {
						// ANDƂʁCcȂ
						return null;
					}
					results[0] = andOperationApplied[0];
					results[i] = andOperationApplied[1];
				}
			}
			// ŌɁC]uCfbNXSEQƂ
			KoikeIndexResultSet[] seqOperationApplied = LogicalOperatorFactory.getOperator(Element.TYPE_SEQ).execute(results);
			if(seqOperationApplied == null) {
				// SEQƂʁCcȂ
				return null;
			}

			// SĂ̍ꂪ݂镶̂ŁČʁ̌ʂɕϊ
			// ̓Iɂ́C1̌ʂɂČʃZbg1Ɏ܂Ƃ߂
			// SĂ̌͑1̈ʒuJnASĂ̍ꂪ݂镶t@Cɂ
			// K1ꂪ܂܂Ă邱ƂASĂ̌ʂ́C1̌ʂƓł
			return seqOperationApplied[0];
		} catch(IndexNotFoundException e) {
			// ̂ǂꂩCfbNXVXeɑ݂Ȃꍇ
			// SĂ̍ꂪAʒuɑ݂ȂΎsȂ̂ŁCG[
			return null;
		} catch(SearchException e) {
			throw e;
		} catch (ParserException e) {
			throw new SearchException(e);
		} catch (IndexAccessException e) {
			throw new SearchException(e);
		} catch (LogicalOperationException e) {
			throw new SearchException(e);
		}
	}
	/**
	 * ʂ\[g邽߂̔rWbNԂD
	 * @return rWbN
	 */
	protected Comparator getComparator() {
		return null;
	}
}
