/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: AndLogicalOperator.java,v 1.2 2005/05/31 14:38:20 rampil Exp $
 */
package org.logical_paradox.koike.rss.search.lo;

import java.util.HashMap;
import java.util.Iterator;

import org.logical_paradox.koike.core.search.InvertedIndex;
import org.logical_paradox.koike.core.search.KoikeIndexResultSet;

/**
 * ANDZq
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.2 $
 */
public class AndLogicalOperator implements LogicalOperator {
	/**
	 * CfbNXVXẻ񓚃Zbgɑ΂Ę_ZKpCʃZbgԂ
	 * @param resultset ZΏ
	 * @return Zʂ̔z(ꂼ̉񓚃Zbgɑ΂Ę_ZKpʂzŕԂ)
	 */
	public KoikeIndexResultSet[] execute(KoikeIndexResultSet[] resultset) throws LogicalOperationException {
		if(resultset == null || resultset.length == 0) {
			// Ȃ̏ꍇ
			return null;
		} else if(resultset.length == 1) {
			// 1݂̂̏ꍇ(=)
			return resultset;
		}
		// ܂Aŏ̍̌ʂ𐮗
		HashMap map = new HashMap();
		for(Iterator it = resultset[0].iteratorInvertedIndexes(); it.hasNext();) {
			InvertedIndex iidx = (InvertedIndex)it.next();
			// ҏWpRs[쐬
			InvertedIndex newIidx = new InvertedIndex(iidx);
			map.put(iidx.getNodeId() + ":" + iidx.getBlockNo(), newIidx);
		}

		KoikeIndexResultSet[] results = new KoikeIndexResultSet[resultset.length];

		KoikeIndexResultSet resultSet = new KoikeIndexResultSet();

		// ̍ɂāCANDZ
		for(int i = 1; i < resultset.length; i++) {
			KoikeIndexResultSet rs = resultset[i];
			try {
				results[i] = (KoikeIndexResultSet)rs.clone();
			} catch (CloneNotSupportedException e) {
				throw new LogicalOperationException(e);
			}
			boolean found = false;

			for(Iterator it = rs.iteratorInvertedIndexes(); it.hasNext();) {
				InvertedIndex iidx = (InvertedIndex)it.next();
				// ꂪ1ƂĎw肳Ă邩ǂ𒲂ׂ
				InvertedIndex invertedIndex = (InvertedIndex)map.get(iidx.getNodeId() + ":" + iidx.getBlockNo());
				if(invertedIndex != null && (invertedIndex.getDocumentAvailability() & iidx.getDocumentAvailability()) > 0) {
					// 1Ɠ̂̂ŁCANDƂ
					found = true;
					long documents = invertedIndex.getDocumentAvailability() & iidx.getDocumentAvailability();
					// documentavailabilityĐݒ肷ƁCKvȂʒuIɏ
					invertedIndex.setDocumentAvailability(documents);
					resultSet.addInvertedIndex(invertedIndex);
				} else {
					// ANDƂ0ɂȂĂ܂̂́A}bv珜Ă
					if(invertedIndex != null) {
						map.remove(invertedIndex.getNodeId() + ":" + invertedIndex.getBlockNo());
						resultSet.removeInvertedIndex(invertedIndex);
					}
					map.remove(iidx.getNodeId() + ":" + iidx.getBlockNo());
					// ̍̌ʃZbg̓]uCfbNX̂Ă
					results[i].removeInvertedIndex(iidx);
				}
			}
			if(found == false) {
				// YɂāC1ƑSvȂ(=ANDfalse)
				map = null;
				return null;
			}
		}

		// ANDtB^
		for(Iterator it = map.values().iterator(); it.hasNext();) {
			InvertedIndex iidx = (InvertedIndex)it.next();

			// SĂ̍ɑ΂ANDtB^(1ȊO)
			for(int i = 1; i < results.length; i++) {
				InvertedIndex target = results[i].getInvertedIndex(iidx);
				if(target != null) {
					results[i].getInvertedIndex(iidx).setDocumentAvailability(iidx.getDocumentAvailability());
				} else {
					resultSet.removeInvertedIndex(target);
				}
			}
		}
		// Ōɑ1̐ݒ
		results[0] = resultSet;

		return results;
	}

}
