/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: LogicalOperatorFactory.java,v 1.2 2005/05/31 14:38:20 rampil Exp $
 */
package org.logical_paradox.koike.rss.search.lo;

import org.logical_paradox.koike.core.search.Element;

/**
 * ʂ̘_ZWbNt@Ng[
 * CfbNXVXẻ񓚂ANDZORZ肷郍WbÑt@Ng
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.2 $
 */
public class LogicalOperatorFactory {
	/** ANDZq */
	private static final LogicalOperator andOperator = new AndLogicalOperator();
	/** ORZq */
	private static final LogicalOperator orOperator = new OrLogicalOperator();
	/** SEQZq */
	private static final LogicalOperator seqOperator = new SeqLogicalOperator();

	/**
	 * _ZIy[^Ԃ
	 * @param type ElementNXŎw肳Ă_Z̃^Cv
	 * @return Ή_Zq
	 */
	public static final LogicalOperator getOperator(int type) {
		switch(type) {
			// AND
			case Element.TYPE_AND:
				return andOperator;
			// OR
			case Element.TYPE_OR:
				return orOperator;
			// SEQ
			case Element.TYPE_SEQ:
				return seqOperator;
			// ̑̃nho^ĂȂZq
			default:
				throw new IllegalArgumentException();
		}
	}
}
