/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: SeqLogicalOperator.java,v 1.2 2005/05/31 14:38:20 rampil Exp $
 */
package org.logical_paradox.koike.rss.search.lo;

import java.util.Iterator;

import org.logical_paradox.koike.core.search.InvertedIndex;
import org.logical_paradox.koike.core.search.KoikeIndexResultSet;
import org.logical_paradox.koike.core.search.Location;

/**
 * SEQZq(IWi)
 * w肳ꂽvfSĘAĂKv
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.2 $
 */
public class SeqLogicalOperator implements LogicalOperator {
	/**
	 * CfbNXVXẻ񓚃Zbgɑ΂Ę_ZKpCʃZbgԂ
	 * @param resultset ZΏ
	 * @return Zʂ̔z(ꂼ̉񓚃Zbgɑ΂Ę_ZKpʂzŕԂ)
	 */
	public KoikeIndexResultSet[] execute(KoikeIndexResultSet[] resultset) throws LogicalOperationException {
		if(resultset == null || resultset.length == 0) {
			// ̂null܂͋z
			return null;
		} else if(resultset.length == 1) {
			// 1̏ꍇA=
			return new KoikeIndexResultSet[] {resultset[0] };
		}
		// 1̈ʒuƂɂāAǐʒu𒲂ׂ
		KoikeIndexResultSet base = resultset[0];
		KoikeIndexResultSet rs = new KoikeIndexResultSet();

		for(Iterator it = base.iteratorInvertedIndexes(); it.hasNext();) {
			// 1̓]uCfbNX̃Rs[쐬āCɔ肷
			InvertedIndex iidx = new InvertedIndex((InvertedIndex)it.next());
			for(Iterator locations = iidx.iteratorLocations(); locations.hasNext();) {
				Location location = (Location)locations.next();
				// ̈ʒu̎̈ʒuAAčꂪzuĂ邩ǂ𒲂ׂ
				int offset = location.getOffset() +1;
				boolean found = true;
				for(int i = 1; found == true && i < resultset.length; i++, offset++) {
					if(resultset[i].isLocated(location.getNodeId(), location.getDocno(), offset) == true) {
						// 
					} else {
						// Ȃ̂Œɏ𒆒f
						found = false;
					}
				}
				if(found == false) {
					// ꂪAĔzuĂȂ̂ŁAʒuj
					iidx.removeLocation(location);
				}
			}
			// ̓]uCfbNXʒuĂꍇAZKpʂƂӖ
			// Ȃ̂ŁAʃZbgɒǉ
			if(iidx.getDocumentAvailability() > 0L) {
				rs.addInvertedIndex(iidx);
			}
		}

		if(rs.isEmpty() == true) {
			// ǈʒu񂪂Ȃ
			return null;
		}
		// ̉Zq͌ʂ1Ԃ(=1̌)
		KoikeIndexResultSet[] result = new KoikeIndexResultSet[1];
		result[0] = rs;

		return result;
	}
}
