/*
 * $Id: SimpleConcreteInterfaceFactory.java,v 1.5 2005/05/31 14:38:20 rampil Exp $
 * Copyright (c) 2004 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.koike.simple;

import java.util.Iterator;

import org.logical_paradox.common.util.Cache;
import org.logical_paradox.koike.core.ConcreteInterfaceFactory;
import org.logical_paradox.koike.core.document.DocumentAccessor;
import org.logical_paradox.koike.core.indexer.IndexAccessor;
import org.logical_paradox.koike.core.search.SearchConditionOptimizer;
import org.logical_paradox.koike.simple.document.LocalQueueCollection;
import org.logical_paradox.koike.simple.document.SimpleDocumentAccessor;
import org.logical_paradox.koike.simple.indexer.SimpleIndexAccessor;

/**
 * X^hA[œ삷^Cv̋ۃC^[tF[Xt@Ng
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.5 $
 */
public class SimpleConcreteInterfaceFactory extends ConcreteInterfaceFactory {
	/**
	 * RXgN^
	 * @param param 
	 * @throws Exception CX^X̐ɔO
	 */
	public SimpleConcreteInterfaceFactory(String param) throws Exception {
		super(param);
	}

	public void setup() throws Exception {
	}

	public DocumentAccessor getDocumentAccessor() throws Exception {
		return new SimpleDocumentAccessor();
	}

	public IndexAccessor getIndexAccessor() throws Exception {
		return new SimpleIndexAccessor();
	}
	/**
	 * L[Rec̃_CWFXg擾Ce[^Ԃ
	 * @return Ce[^(vf̈SɓĂ^Cv)
	 */
	public Iterator getRemoteQueueIterator() throws Exception {
		LocalQueueCollection.load(SimpleSetConstant.LOCAL_CONTENTS_DIR);
		Cache cache = LocalQueueCollection.getQueue(); 
		return cache.iterator();
	}

	/* ( Javadoc)
	 * @see org.logical_paradox.koike.core.ConcreteInterfaceFactory#getOptimizer()
	 */
	public SearchConditionOptimizer getOptimizer() throws Exception {
		// TODO ꂽ\bhEX^u
		return null;
	}

}
