/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: ParserTest.java,v 1.1 2005/05/31 14:38:20 rampil Exp $
 */
package org.logical_paradox.koike.core.parser;

import java.util.Iterator;

import junit.framework.TestCase;

/**
 * n-gramp[U[̃eXg
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.1 $
 */
public class ParserTest extends TestCase {

	/**
	 * Constructor for ParserTest.
	 * @param arg0
	 */
	public ParserTest(String arg0) {
		super(arg0);
	}
	/**
	 * n-gramɑ΂ăeLXgZꍇ̃eXg
	 */
	public void testTooShortDocument() throws ParserException {
		String text = "n-gramɑ΂";

		Parser p = new Parser(12);
		try {
			p.parse(text);
			fail();
		} catch(ParserException e) {
			// OK
		}

		p = new Parser(11);
		p.parse(text);
	}
	/**
	 * n-gram̃eXg
	 * @throws ParserException ɔO
	 */
	public void testParserResult() throws ParserException {
		String text = "ɔO";

		Term[] terms = new Parser(2).parse(text);

		assertTrue(contains(terms, ""));
		assertTrue(contains(terms, ""));
		assertTrue(contains(terms, ""));
		assertTrue(contains(terms, ""));
		assertTrue(contains(terms, ""));
		assertTrue(contains(terms, "ɔ"));
		assertTrue(contains(terms, ""));
		assertTrue(contains(terms, ""));
		assertTrue(contains(terms, ""));
		assertTrue(contains(terms, ""));
		assertTrue(contains(terms, "O"));
		assertTrue(contains(terms, "O"));

		assertEquals(12, terms.length);

		Term term = getTerm(terms, "");
		Iterator it = term.iterator();

		assertTrue(it.hasNext());
		assertEquals(2, ((Integer)it.next()).intValue());
		assertTrue(it.hasNext());
		assertEquals(12, ((Integer)it.next()).intValue());
		assertFalse(it.hasNext());
	}
	/**
	 * wz񒆂Ɏw肵ꂪi[Ă邩ǂԂ
	 * @param base Ώۂ̔z
	 * @param term T
	 * @return ꂽ
	 */
	protected Term getTerm(Term[] base, String term) {
		for(int i = 0; i < base.length; i++) {
			if(base[i].getTerm().equals(term)) {
				return base[i];
			}
		}
		return null;
	}
	/**
	 * w肳ꂽɁAꂪ܂܂Ă邩ǂԂ
	 * @param base ƂĂ̔z
	 * @param term 
	 * @return true: / false:Ȃ
	 */
	protected boolean contains(Term[] base, String term) {
		return getTerm(base, term) != null;
	}
}
