/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: InvertedIndexTest.java,v 1.1 2005/05/31 14:38:20 rampil Exp $
 */
package org.logical_paradox.koike.core.search;

import java.util.Iterator;

import junit.framework.TestCase;

/**
 * InvertedIndex̃eXg
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.1 $
 */
public class InvertedIndexTest extends TestCase {

	/**
	 * Constructor for InvertedIndexTest.
	 * @param arg0
	 */
	public InvertedIndexTest(String arg0) {
		super(arg0);
	}
	/**
	 * equals()̃eXg
	 * m[hID,blocknoĂOK<br>
	 * documentsƈʒu͍lȂ
	 */
	public void testEquals() {
		InvertedIndex a = new InvertedIndex("NODEID00001", 1002, 12);
		InvertedIndex b = new InvertedIndex("NODEID00001", 1002, 292);

		assertEquals(a, b);
	}
	/**
	 * equals()sꍇ̃eXg
	 * m[hID,blocknoႦNG<br>
	 */
	public void testNotEquals() {
		InvertedIndex a = new InvertedIndex("NODEID00001", 1002, 12);
		InvertedIndex b = new InvertedIndex("NODEID00002", 1002, 292);

		assertFalse(a.equals(null));
		assertFalse(a.equals(b));

		b = new InvertedIndex("NODEID00001", 1302, 292);
		assertFalse(a.equals(b));
	}
	/**
	 * hashcodeꍇ̃eXg
	 */
	public void testHashCodeEquals() {
		InvertedIndex a = new InvertedIndex("NODEID00001", 1002, 12);
		InvertedIndex b = new InvertedIndex("NODEID00001", 1002, 292);

		assertEquals(a.hashCode(), b.hashCode());
	}
	/**
	 * hashcodeႤꍇ̃eXg
	 */
	public void testHashCodeNotEquals() {
		InvertedIndex a = new InvertedIndex("NODEID00001", 1002, 12);
		InvertedIndex b = new InvertedIndex("NODEID00002", 1002, 292);

		assertFalse(a.hashCode() == b.hashCode());

		b = new InvertedIndex("NODEID00001", 1003, 12);
		assertFalse(a.hashCode() == b.hashCode());
	}
	/**
	 * equals()hashCode()̑݊֘AɊւeXg
	 */
	public void testEqualsAndHashCodeRelation() {
		InvertedIndex a = new InvertedIndex("NODEID00001", 1002, 12);
		InvertedIndex b = new InvertedIndex("NODEID00001", 1002, 292);

		assertTrue(a.equals(b) && a.hashCode() == b.hashCode());
	}
	/**
	 * getLocation()̃eXg
	 */
	public void testGettingLocation() {
		InvertedIndex src = new InvertedIndex("NODE00001", 2999, 121);
		Location l1 = new Location("NODE00001", 32768, 1992);
		Location l2 = new Location("NODE00001", 16384, 999);
		src.addLocation(l1);
		src.addLocation(l2);

		// ݂
		assertSame(l1, src.getLocation(32768, 1992));
		assertSame(l2, src.getLocation(16384, 999));
		// ݂Ȃ
		assertNotSame(l1, src.getLocation(16383, 332));
	}
	/**
	 * ʒu폜̃eXg
	 */
	public void testRemovingLocation() {
		InvertedIndex src = new InvertedIndex("NODE00001", 1, 3);		// 64,65on
		Location l1 = new Location("NODE00001", 64, 1992);
		Location l2 = new Location("NODE00001", 65, 999);
		Location l3 = new Location("NODE00001", 65, 1024);
		src.addLocation(l1);
		src.addLocation(l2);
		src.addLocation(l3);

		// l1폜
		// docno=641ʒu񂪂Ȃ̂,documents2ɕω
		src.removeLocation(new Location("NODE00001", 64, 1992));

		assertNull(src.getLocation(64,1992));
		assertEquals(2, src.getDocumentAvailability());

		// l2폜
		// docno=65ɂ2̂ŁAЕĂ܂
		src.removeLocation(new Location("NODE00001", 65, 999));
		assertNull(src.getLocation(65,999));
		assertNotNull(src.getLocation(65, 1024));
		assertEquals(2, src.getDocumentAvailability());
	}
	/**
	 * ]u̍Đݒ̃eXg
	 * Zbgꂽ̂ɂāAʒu񂪍폜Ă邱
	 */
	public void testResetDocumentAvailability() {
		InvertedIndex src = new InvertedIndex("NODE00001", 1, 3);		// 64,65on
		Location l1 = new Location("NODE00001", 64, 1992);
		Location l2 = new Location("NODE00001", 65, 999);
		Location l3 = new Location("NODE00001", 65, 1024);
		src.addLocation(l1);
		src.addLocation(l2);
		src.addLocation(l3);

		// documents = 1ɐݒ(l2l3폜)
		src.setDocumentAvailability(1);

		// l1͂
		assertNotNull(src.getLocation(64, 1992));
		// l2͂Ȃ
		assertNull(src.getLocation(65, 999));
		// l3Ȃ
		assertNull(src.getLocation(65, 1024));
	}
	/**
	 * ʒuCe[^̃eXg
	 * ႤԍłAAXgƂĎQƂł邱ƂmF
	 */
	public void testLocationIterator() {
		InvertedIndex src = new InvertedIndex("NODE00001", 1, 3);		// 64,65on
		Location l1 = new Location("NODE00001", 64, 1992);
		Location l2 = new Location("NODE00001", 65, 999);
		Location l3 = new Location("NODE00001", 65, 1024);
		src.addLocation(l1);
		src.addLocation(l2);
		src.addLocation(l3);

		Iterator it = src.iteratorLocations();
		Object o = it.next();
		assertTrue(l1 == o || l2 == o || l3 == o);
		o = it.next();
		assertTrue(l1 == o || l2 == o || l3 == o);
		o = it.next();
		assertTrue(l1 == o || l2 == o || l3 == o);

		// Ȃ͂
		assertFalse(it.hasNext());
	}
	/**
	 * Rs[RXgN^̃eXg
	 */
	public void testCopyConstructor() {
		InvertedIndex src = new InvertedIndex("NODE00001", 2999, 121);
		Location l1 = new Location("NODE00001", 32768, 1992);
		Location l2 = new Location("NODE00001", 16384, 999);
		src.addLocation(l1);
		src.addLocation(l2);

		InvertedIndex dst = new InvertedIndex(src);
		assertEquals(src.getNodeId(), dst.getNodeId());
		assertEquals(src.getBlockNo(), dst.getBlockNo());
		assertEquals(src.getDocumentAvailability(), dst.getDocumentAvailability());

		assertEquals(src, dst);

		// ʒu̔r
		// ʒu͓CX^X擾ł
		assertSame(src.getLocation(32768, 1992), dst.getLocation(32768, 1992));
		assertSame(src.getLocation(16384, 999), dst.getLocation(16384, 999));
	}
	/**
	 * clone()̃eXg
	 */
	public void testClone() throws CloneNotSupportedException {
		InvertedIndex src = new InvertedIndex("NODE00001", 2999, 121);
		Location l1 = new Location("NODE00001", 32768, 1992);
		Location l2 = new Location("NODE00001", 16384, 999);
		src.addLocation(l1);
		src.addLocation(l2);

		InvertedIndex dst = (InvertedIndex)src.clone();
		assertEquals(src.getNodeId(), dst.getNodeId());
		assertEquals(src.getBlockNo(), dst.getBlockNo());
		assertEquals(src.getDocumentAvailability(), dst.getDocumentAvailability());

		assertEquals(src, dst);

		// ʒu̔r
		// ʒu͓CX^X擾ł
		assertSame(src.getLocation(32768, 1992), dst.getLocation(32768, 1992));
		assertSame(src.getLocation(16384, 999), dst.getLocation(16384, 999));
	}
}
