/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: KoikeIndexResultSetTest.java,v 1.1 2005/05/31 14:38:20 rampil Exp $
 */
package org.logical_paradox.koike.core.search;

import java.util.Iterator;

import junit.framework.TestCase;

/**
 * KoikeIndexResultSet̃eXg
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.1 $
 */
public class KoikeIndexResultSetTest extends TestCase {

	/**
	 * Constructor for KoikeIndexResultSetTest.
	 * @param arg0
	 */
	public KoikeIndexResultSetTest(String arg0) {
		super(arg0);
	}
	/**
	 * ]uCfbNX̐ʃeXg
	 * 󂩂ǂ𐳂ł邱
	 */
	public void testInvertedIndexCount() {
		KoikeIndexResultSet rs = new KoikeIndexResultSet();

		assertTrue(rs.isEmpty());

		// Kɒǉ
		rs.addInvertedIndex(new InvertedIndex("NODE00001", 32, 15));
		assertFalse(rs.isEmpty());

		// ǉ̂폜
		rs.removeInvertedIndex(new InvertedIndex("NODE00001", 32, 100));
		assertTrue(rs.isEmpty());
	}
	/**
	 * clone()̃eXg
	 */
	public void testClone() throws CloneNotSupportedException {
		KoikeIndexResultSet rs = new KoikeIndexResultSet();
		InvertedIndex i1 = new InvertedIndex("NODE00001", 32, 15);
		InvertedIndex i2 = new InvertedIndex("NODE00001", 33, 24);
		InvertedIndex i3 = new InvertedIndex("NODE00002", 99, 124);
		rs.addInvertedIndex(i1);
		rs.addInvertedIndex(i2);
		rs.addInvertedIndex(i3);

		KoikeIndexResultSet rs2 = (KoikeIndexResultSet)rs.clone();

		Iterator it1 = rs.iteratorInvertedIndexes();
		Iterator it2 = rs2.iteratorInvertedIndexes();

		assertEquals(it1.next(), it2.next());
		assertEquals(it1.next(), it2.next());
		assertEquals(it1.next(), it2.next());
	}
	/**
	 * clear()̃eXg
	 * \bhďoAisEmpty() == trueƂȂ
	 */
	public void testClear() {
		KoikeIndexResultSet rs = new KoikeIndexResultSet();
		InvertedIndex i1 = new InvertedIndex("NODE00001", 32, 15);
		InvertedIndex i2 = new InvertedIndex("NODE00001", 33, 24);
		InvertedIndex i3 = new InvertedIndex("NODE00002", 99, 124);
		rs.addInvertedIndex(i1);
		rs.addInvertedIndex(i2);
		rs.addInvertedIndex(i3);

		assertFalse(rs.isEmpty());
		rs.clear();

		assertTrue(rs.isEmpty());
	}
}
