/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: LocationTest.java,v 1.1 2005/05/31 14:38:20 rampil Exp $
 */
package org.logical_paradox.koike.core.search;

import junit.framework.TestCase;

/**
 * ̈ʒuNX̃eXg
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.1 $
 */
public class LocationTest extends TestCase {

	/**
	 * Constructor for LocationTest.
	 * @param arg0
	 */
	public LocationTest(String arg0) {
		super(arg0);
	}
	/**
	 * equals()trueƂȂꍇ̃eXg
	 */
	public void testEquals() {
		Location a = new Location("ABCDEFG-xxxdddyyyz", 321, 900);
		Location b = new Location("ABCDEFG-xxxdddyyyz", 321, 900);

		assertEquals(a,b);
	}
	/**
	 * equals()falseƂȂꍇ̃eXg
	 *
	 */
	public void testNotEquals() {
		Location a = new Location("ABCDEFG-xxxdddyyyz", 321, 900);
		Location b = new Location("ABCDEFG-xxdddyyyz", 321, 900);

		assertFalse(a.equals(b));

		b = new Location("ABCDEFG-xxxdddyyyz", 320, 900);
		assertFalse(a.equals(b));

		b = new Location("ABCDEFG-xxxdddyyyz", 321, 920);
		assertFalse(a.equals(b));

		b = null;
		assertFalse(a.equals(b));
	}
	/**
	 * hashcodeɂȂꍇ̃eXg
	 */
	public void testHashCodeEquals() {
		Location a = new Location("ABCDEFG-xxxdddyyyz", 321, 900);
		Location b = new Location("ABCDEFG-xxxdddyyyz", 321, 900);

		assertEquals(a.hashCode(),b.hashCode());
	}
	/**
	 * hashcodeႤlɂȂꍇ̃eXg
	 */
	public void testHashCodeNotEquals() {
		Location a = new Location("ABCDEFG-xxxdddyyyz", 321, 900);
		Location b = new Location("ABCDEFG-xxdddyyyz", 321, 900);

		assertFalse(a.hashCode() == b.hashCode());
	}
	/**
	 * equals()hashOode()̑݊֌WɂẴeXg
	 * equals()ł΁AhashCode()łKv
	 */
	public void testEqualsAndHashCodeRelation() {
		Location a = new Location("ABCDEFG-xxxdddyyyz", 321, 900);
		Location b = new Location("ABCDEFG-xxxdddyyyz", 321, 900);

		assertTrue(a.equals(b) && a.hashCode() == b.hashCode());
	}
	/**
	 * clone()̊SɊւeXg
	 */	
	public void testClone() throws CloneNotSupportedException {
		Location a = new Location("ABCDEFG-xxxdddyyyz", 321, 900);
		Location b = (Location)a.clone();

		assertEquals(a.getNodeId(), b.getNodeId());
		assertEquals(a.getDocno(), b.getDocno());
		assertEquals(a.getOffset(), b.getOffset());
		assertTrue(a.equals(b) && a.hashCode() == b.hashCode());
	}
}
