/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: DefaultSummaryGeneratorTest.java,v 1.2 2005/05/31 14:38:20 rampil Exp $
 */
package org.logical_paradox.koike.core.summary;

import junit.framework.TestCase;

/**
 * DefaultSummaryGenerator̃eXgP[X
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.2 $
 */
public class DefaultSummaryGeneratorTest extends TestCase {
	/** eXgp̃eLXg */
	public static final String TARGET_DOCUMENT =
		"Open-SEDḰA{bg^T[`GWĴ`鑼ɁAvO~OƂlXɑ΂āAyĎhIȃI`񋟂ړI܂B\n" +
		"ۂɂǂ̂悤ɂėVׂ΂悢ɂẮAiKIɗᎦĂƍlĂ܂B\n" +
		"I[v\[X̃vWFNgł̂ŁÂ܂܎pA邢͎pړĨT[`GWĴ͎~߂܂񂪁AuyvVłƁAJ҂ƂĂ͊v܂B";

	/**
	 * Constructor for DefaultSummaryGeneratorTest.
	 * @param arg0
	 */
	public DefaultSummaryGeneratorTest(String arg0) {
		super(arg0);
	}
	/**
	 * ]|CgṽeXg
	 */
	public void testEvaluationCalculation() {
		final String summary = "̂܂܎pA邢͎pړĨT[`GWĴ͎~߂܂񂪁A";
		final String[] terms = new String[] {"","p","T[`GW","eLXg"};
		int summaryLength = summary.length();

		DefaultSummaryGenerator.EvaluationPoint evalp = new DefaultSummaryGenerator(summaryLength).eval(summary, 199, terms);
		// distance  = 13 * 100 / 40 = 32.5
		// variation = 3 * 100 / 4 = 75
		// totalscore= 32+75*9 = 707
		assertEquals(707, evalp.getLocationScore());

		// ʂ̃T}[𓯂ŃeXg(菭Ȃ) uT[`GWvuGWv
		final String summary2 = "̂܂܎pA邢͎pړǏGWĴ͎~߂܂񂪁A";

		DefaultSummaryGenerator.EvaluationPoint evalp2 = new DefaultSummaryGenerator(summaryLength).eval(summary2, 200, terms);
		// distance  = 6 * 100 / 40 = 15
		// variation = 2 * 100 / 4 = 50
		// totalscore= 15+50*9 = 707
		assertEquals(465, evalp2.getLocationScore());

		// ŏ̃T}[̂ق悩͂
		assertTrue(evalp2.getLocationScore() < evalp.getLocationScore());
	}
	/**
	 * T}[쐬̃eXg001
	 * {̓rIꍇ
	 */
	public void testSummaryCreation001() {
		final int summaryLength = 15;
		final String[] terms = new String[] {"","p","{bg","܂"};

		// T}[쐬(T}[=15)
		String summary = new DefaultSummaryGenerator(summaryLength).createSummary(TARGET_DOCUMENT, terms);

		assertEquals("..̂܂܎pA邢͎..", summary);
	}
	/**
	 * T}[쐬̃eXg002
	 * {̍ŏIꍇ
	 */
	public void testSummaryCreation002() {
		final int summaryLength = 15;
		final String[] terms = new String[] {"Open-SEDK"};

		// T}[쐬(T}[=15)
		String summary = new DefaultSummaryGenerator(summaryLength).createSummary(TARGET_DOCUMENT, terms);

		assertEquals("Open-SEDḰA{bg..", summary);
	}
	/**
	 * T}[쐬̃eXg003
	 * {̍ŌオIꍇ
	 */
	public void testSummaryCreation003() {
		final int summaryLength = 15;
		final String[] terms = new String[] {"v܂B"};

		// T}[쐬(T}[=15)
		String summary = new DefaultSummaryGenerator(summaryLength).createSummary(TARGET_DOCUMENT, terms);

		assertEquals("..J҂ƂĂ͊v܂B", summary);
	}
}
