/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: EvaluationPointTest.java,v 1.2 2005/05/31 14:38:20 rampil Exp $
 */
package org.logical_paradox.koike.core.summary;

import java.util.ArrayList;
import java.util.Collections;

import junit.framework.TestCase;

/**
 * DefaultSummaryGenerator.EvaluationPointNX̃eXg
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.2 $
 */
public class EvaluationPointTest extends TestCase {

	/**
	 * Constructor for EvaluationPointTest.
	 * @param arg0
	 */
	public EvaluationPointTest(String arg0) {
		super(arg0);
	}
	/**
	 * ]|Cg̊S
	 */
	public void testEvaluationPointCalculationCorrectivity() {
		DefaultSummaryGenerator.EvaluationPoint p = new DefaultSummaryGenerator().new EvaluationPoint("T}", 102, 100, 100);

		// T}[
		assertEquals("T}", p.getSummary());
		// ʒu
		assertEquals(102, p.getPos());
		// щ񐔃|Cg
		assertEquals(100, p.getDistanceScore());
		// ސ|Cg
		assertEquals(100, p.getVariationScore());
		// ]|Cg
		assertEquals(1000, p.getLocationScore());
	}
	/**
	 * ]|Cg̃\[gI[_[
	 * Collections.sort()Ń\[gہA]|Cg̑傫Ƀ\[g邱
	 */
	public void testSortOrder() {
		ArrayList points = new ArrayList();
		points.add(new DefaultSummaryGenerator().new EvaluationPoint("T}1", 102, 100, 100));	// 1000
		points.add(new DefaultSummaryGenerator().new EvaluationPoint("T}2", 103, 15, 100));	// 915
		points.add(new DefaultSummaryGenerator().new EvaluationPoint("T}3", 105, 100, 15));	// 235
		points.add(new DefaultSummaryGenerator().new EvaluationPoint("T}4", 99, 44, 55));		// 539
		points.add(new DefaultSummaryGenerator().new EvaluationPoint("T}5", 101, 3, 10));		// 93

		// \[g
		Collections.sort(points);

		assertEquals(1000, ((DefaultSummaryGenerator.EvaluationPoint)points.get(0)).getLocationScore());
		assertEquals(915, ((DefaultSummaryGenerator.EvaluationPoint)points.get(1)).getLocationScore());
		assertEquals(539, ((DefaultSummaryGenerator.EvaluationPoint)points.get(2)).getLocationScore());
		assertEquals(235, ((DefaultSummaryGenerator.EvaluationPoint)points.get(3)).getLocationScore());
		assertEquals(93, ((DefaultSummaryGenerator.EvaluationPoint)points.get(4)).getLocationScore());
	}
}
