/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: LocationTest.java,v 1.2 2005/05/31 14:38:20 rampil Exp $
 */
package org.logical_paradox.koike.core.summary;

import java.util.ArrayList;
import java.util.Collections;

import junit.framework.TestCase;

/**
 * DefaultSummaryGenerator.LocationNX̃eXg
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.2 $
 */
public class LocationTest extends TestCase {

	/**
	 * Constructor for LocationTest.
	 * @param arg0
	 */
	public LocationTest(String arg0) {
		super(arg0);
	}
	/**
	 * setters/getters̊SeXg
	 */
	public void testObjectCorrectivity() {
		DefaultSummaryGenerator.Location location = new DefaultSummaryGenerator().new Location(100, "", 4096);

		// ޔԍ
		assertEquals(100, location.index);
		// 
		assertEquals("", location.term);
		// ʒu
		assertEquals(4096, location.pos);
	}
	/**
	 * \[gI[_[̃eXg
	 * Collections.sort()ꍇɁCɃ\[g邱
	 */
	public void testSortOrder() {
		ArrayList locations = new ArrayList();
		locations.add(new DefaultSummaryGenerator().new Location(100, "", 4096));
		locations.add(new DefaultSummaryGenerator().new Location(105, "", 99));
		locations.add(new DefaultSummaryGenerator().new Location(12, "", 23));
		locations.add(new DefaultSummaryGenerator().new Location(9, "", 105));
		locations.add(new DefaultSummaryGenerator().new Location(-3, "", 102));

		// \[g
		Collections.sort(locations);

		assertEquals(23, ((DefaultSummaryGenerator.Location)locations.get(0)).pos);
		assertEquals(99, ((DefaultSummaryGenerator.Location)locations.get(1)).pos);
		assertEquals(102, ((DefaultSummaryGenerator.Location)locations.get(2)).pos);
		assertEquals(105, ((DefaultSummaryGenerator.Location)locations.get(3)).pos);
		assertEquals(4096, ((DefaultSummaryGenerator.Location)locations.get(4)).pos);
	}
}
