/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: RSSSearchEngineTest.java,v 1.3 2005/11/06 14:46:32 rampil Exp $
 */
package org.logical_paradox.koike.rss.search;

import java.util.List;
import java.util.Properties;

import junit.framework.TestCase;

import org.logical_paradox.koike.core.KoikeConfig;
import org.logical_paradox.koike.core.KoikeConstant;
import org.logical_paradox.koike.core.search.Element;
import org.logical_paradox.koike.core.search.KoikeIndexResultSet;
import org.logical_paradox.koike.core.search.ResultSet;
import org.logical_paradox.koike.core.search.SearchCondition;
import org.logical_paradox.koike.core.search.SearchException;
import org.logical_paradox.koike.core.search.SearchResult;
import org.logical_paradox.koike.tools.isys.StubIndexAccessor;

/**
 * RSS/1bT[`GW̃eXg
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.3 $
 */
public class RSSSearchEngineTest extends TestCase {
	/** eXgpT[`GW̃CX^X */
	private RSSSearchEngineImpl searchEngine;

	/**
	 * Constructor for RSSSearchEngineTest.
	 * @param arg0
	 */
	public RSSSearchEngineTest(String arg0) {
		super(arg0);
	}

	/**
	 * TeXg01
	 * ЂŃeXg
	 */
	public void testExecuteQueryAndFoundAnswers() throws SearchException {
		KoikeIndexResultSet rs = searchEngine.executeQuery("T[`GW");

		assertNotNull(rs);
		assertFalse(rs.isEmpty());
	}
	/**
	 * TeXg02
	 * ЂȂŃeXg
	 */
	public void testExecuteQueryAndNotFound() throws SearchException {
		KoikeIndexResultSet rs = searchEngine.executeQuery("CfNX");

		assertNull(rs);
	}
	/**
	 * TeXg03
	 * ꒷ZŌ悤Ƃꍇ̃eXg
	 */
	public void testExecuteQueryWith1Letter() {
		try {
			searchEngine.executeQuery("C");
			fail();
		} catch(SearchException se) {
			// OK
		}
	}
	/**
	 * 1AND
	 */
	public void testSearchWith1Word() throws SearchException {
		// ܂쐬
		// <AND>
		//   <TERM>Open-SEDK</TERM>
		// </AND>
		SearchCondition condition = new SearchCondition();
		condition.setDispnum(10);
		condition.setStartp(0);

		Element e = new Element(Element.TYPE_TERM, "Open-SEDK");
		condition.addChildNode(e);

		// 
		SearchResult sr = searchEngine.search(condition);
		ResultSet[] results = sr.getResultSet();

		// NODE00001:01:0,60,320,535,546,596,945,1057
		// NODE00001:02:338,1423
		assertNotNull(results);
		assertTrue(results.length == 2);
	}
	/**
	 * 1ANDŁAʂȂꍇ̃eXg
	 */
	public void testSearchAndNotFound() throws SearchException {
		// ܂쐬
		// <AND>
		//   <TERM>Open-SEDK</TERM>
		// </AND>
		SearchCondition condition = new SearchCondition();
		condition.setDispnum(10);
		condition.setStartp(0);

		Element e = new Element(Element.TYPE_TERM, "Open-SpDK");
		condition.addChildNode(e);

		// 
		SearchResult sr = searchEngine.search(condition);
		assertNull(sr);
	}
	/**
	 * 2AND
	 */
	public void testSearchWith2Word() throws SearchException {
		// ܂쐬
		// <AND>
		//   <TERM>Open-SEDK</TERM>
		//   <TERM>secure</TERM>
		// </AND>
		SearchCondition condition = new SearchCondition();
		condition.setDispnum(10);
		condition.setStartp(0);

		condition.addChildNode(new Element(Element.TYPE_TERM, "Open-SEDK"));
		condition.addChildNode(new Element(Element.TYPE_TERM, "SETI@home݂Ȋ"));
		// 
		SearchResult sr = searchEngine.search(condition);
		ResultSet[] results = sr.getResultSet();

		// NODE00001:01
		assertNotNull(results);
		assertTrue(results.length == 1);
	}
	/**
	 * eXgp̃ZbgAbv
	 */
	protected void setUp() throws Exception {
		super.setUp();
		// eXgp̃bp[𐶐
		Properties p = new Properties();
		// ۃC^[tF[Xt@Ng
		p.setProperty(KoikeConstant.KEY_INTERFACE_FACTORY, "org.logical_paradox.koike.tools.isys.StubConcreteInterfaceFactory");
		// n-gram
		p.setProperty(KoikeConstant.KEY_N_GRAM_TERM_LENGTH, "2");
		KoikeConfig config = new KoikeConfig(p);

		searchEngine = new RSSSearchEngineImpl(config);
	}

	/**
	 * eXgp̃bp[NX
	 * @author satoshi akabane@logical-paradox.org
	 * @version $Revision: 1.3 $
	 */
	class RSSSearchEngineImpl extends RSSSearchEngine {
		/**
		 * RXgN^
		 * @param config RtBO[V
		 * @throws Exception CX^X̐Ɏs
		 */
		public RSSSearchEngineImpl(KoikeConfig config) throws Exception {
			super(config);
		}
		/**
		 * executeQuery()publicŌJ邽߂̃bp[\bh
		 */
		public KoikeIndexResultSet executeQuery(String keyword) throws SearchException {
			return super.executeQuery(keyword);
		}
		/**
		 * ̃T[`GW(X^u)̏
		 * SearchEngine#init()I[o[Ch邽
		 */
		protected void init() throws Exception {
			// CfbNXANZT(CfbNXt@C̃[h)
			StubIndexAccessor stubixr = (StubIndexAccessor)getIndexAccessor();
			stubixr.load();
		}

		/**
		 * vf₢킹Čʂ擾
		 */
		public KoikeIndexResultSet retrieve(List searchWords, Element element) throws SearchException {
			return super.retrieve(searchWords, element);
		}
	}
}
