/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: IndexGenerator.java,v 1.3 2005/06/19 15:14:34 rampil Exp $
 */
package org.logical_paradox.koike.tools.isys;

import java.io.File;

import org.logical_paradox.common.io.FileUtils;
import org.logical_paradox.koike.core.indexer.IndexAccessor;
import org.logical_paradox.koike.core.parser.Parser;
import org.logical_paradox.koike.core.parser.Term;

/**
 * [Jœ삷X^upCfbNXVXeŎgpACfbNX𐶐c[
 * 2-gramœKɐ؂oČ₷CfbNXt@C𐶐<br>
 * t@CtH[}bg͒ʏpropertiest@CƓ(L[=l)
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.3 $
 */
public class IndexGenerator {
	/** ftHg̃f[^zuʒu */
	public static final String DEFAULT_DATA_PATH = StubProperty.getProperty("docs.stubs.isys");
	/** ftHg̃hLgGR[fBO(Unicode big-endian) */
	public static final String DEFAULT_DOCUMENT_ENCODING = "UnicodeBig";
	/** ftHgn-gram */
	public static final int DEFAULT_NGRAM_LENGTH = 2;

	/** hLgf[^pX */
	private final String datapath;
	/**
	 * RXgN^
	 * @param datapath ͑Ώۂ̃hLg݂̑pX
	 */
	public IndexGenerator(String datapath_) {
		datapath = datapath_;
	}
	/**
	 * CfbNX𐶐
	 * @throws Exception ɔO(unhandled)
	 */
	public void execute() throws Exception {
		// CfbNXANZT̐
		IndexAccessor idxa = new StubIndexAccessor();

		File datadir = new File(datapath);
		if(datadir.isDirectory() == false) {
			throw new IllegalArgumentException("w肳ꂽpX̓fBNgł͂܂");
		}

		// p[U[̐
		Parser parser = new Parser(DEFAULT_NGRAM_LENGTH);

		File[] nodelist = datadir.listFiles();
		for(int i = 0; i < nodelist.length; i++) {
			if(
				nodelist[i].isDirectory() == false ||
				nodelist[i].getName().equals(".") ||
				nodelist[i].getName().equals("..") ||
				"CVS".equals(nodelist[i].getName())
			) {
				// hbgfBNgC܂̓fBNgȊȌꍇ͖
				continue;
			}

			File[] documents = nodelist[i].listFiles();
			for(int j = 0; j < documents.length; j++) {		// j = t@Cԍ
				if(documents[j].isFile() == false) {
					continue;
				}
				// hLgt@C̉
				String document = FileUtils.readFully(documents[j], DEFAULT_DOCUMENT_ENCODING);
				// n-gram̐
				Term[] terms = parser.parse(document);
				idxa.addTerm(nodelist[i].getName() + ":" + j, terms);
			}
		}

		// SẴm[h/t@Cɂĉ͂̂
		// CfbNXt@Co͂
		idxa.close();
	}
	/**
	 * C\bh
	 * @param args vO
	 * @throws Exception ȂO
	 */
	public static final void main(String[] args) throws Exception {
		String configfilename = DEFAULT_DATA_PATH;
		if(args.length == 1) {
			// 1̏ꍇApXw肳ꂽ
			configfilename = args[0];
		}

		System.out.println("X^up̃CfbNXt@Co͂܂");

		IndexGenerator idxg = new IndexGenerator(configfilename);
		idxg.execute();

		System.out.println("X^up̃CfbNXt@Co͂܂");
	}
}
// end of IndexGenerator.java
