/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: StubDocumentAccessor.java,v 1.1 2005/05/31 14:38:20 rampil Exp $
 */
package org.logical_paradox.koike.tools.isys;

import java.io.File;

import org.logical_paradox.common.io.FileUtils;
import org.logical_paradox.common.util.StringUtils;
import org.logical_paradox.koike.core.document.Document;
import org.logical_paradox.koike.core.document.DocumentAccessor;
import org.logical_paradox.koike.rss.document.ContentsAttribute;

/**
 * hLgVXeɐڑC^[tF[X
 * X^up
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.1 $
 */
public class StubDocumentAccessor implements DocumentAccessor {
	/**
	 * hLg擾
	 * @param key ʂL[(m[hID:ԍ)
	 */
	public Document getDocument(String key) throws Exception {
		String[] tokens = key.split(":");
		if(tokens == null || tokens.length != 2) {
			throw new IllegalArgumentException();
		}

		String filename =
			IndexGenerator.DEFAULT_DATA_PATH + File.separator +				// f[^pX
			tokens[0] + File.separator +									// m[hID
			StringUtils.formatColumns(Integer.parseInt(tokens[1])+1, 8) +	// t@C
			".txt";

		Document document = new Document();
		document.setDocument(FileUtils.readFully(filename, "UnicodeBig"));

		// RSS/1b̖₢킹Ԃ
		ContentsAttribute attribute = new ContentsAttribute();
		// TCg͉Ƀm[hIDƂ
		attribute.setSitename(tokens[0]);
		// ^Cg̓hLgԍƂ
		attribute.setTitle("TITLE" + tokens[1]);
		// URL͓Kɐ
		attribute.setUrl("http://www.logical-paradox.org/" + tokens[0] + "/index.html");

		document.setAttribute(attribute);
		return document;
	}

	/**
	 * ̃X^uC^[tF[X
	 * UnsupportedOperationExceptionԂ(N[Y̓T|[gĂȂ̂)
	 * @throws Exception N[YɌoO
	 */
	public void close() throws Exception {
		throw new UnsupportedOperationException();
	}

	/**
	 * [g̃hLgǗVXeƂ̐ڑN[YĂ邩ǂԂ
	 * ̃X^uł͏falseԂ
	 * @return true:ڑ / false:ؒfς
	 */
	public boolean isClosed() {
		return false;
	}

}
