/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: StubIndexAccessor.java,v 1.2 2005/06/19 15:14:34 rampil Exp $
 */
package org.logical_paradox.koike.tools.isys;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;

import org.logical_paradox.koike.core.KoikeConstant;
import org.logical_paradox.koike.core.indexer.IndexAccessException;
import org.logical_paradox.koike.core.indexer.IndexAccessor;
import org.logical_paradox.koike.core.parser.Term;
import org.logical_paradox.koike.core.search.InvertedIndex;
import org.logical_paradox.koike.core.search.KoikeIndexResultSet;
import org.logical_paradox.koike.core.search.Location;

/**
 * X^up̃CfbNXVXeɐڑANZT
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.2 $
 */
public class StubIndexAccessor implements IndexAccessor {
	/** vpeBt@C */
	private Properties index = new Properties();
	/** X^uCfbNXVXepCfbNXt@C̔zuʒu */
	public static final String STUB_INDEX_DATADIR = StubProperty.getProperty("data.stub");
	/** X^uCfbNXVXẽCfbNXt@C */
	public static final String STUB_INDEX_DATAFILE = STUB_INDEX_DATADIR + File.separator + "stub.index";

	/** ڑĂ邩ǂ */
	private boolean closed = false;

	/**
	 * ڑƂĂ邩ǂ
	 * @return true:Ă / false:JĂ
	 */
	public boolean isClosed() {
		return closed;
	}

	/**
	 * ڑ
	 * ڑ̃N[YƓɃCfbNX̓et@C֏o͂<br>
	 * t@C̓hLgԍƂɏo͂
	 */
	public void close() throws IndexAccessException {
		try {
			// vpeBt@Co͂
			index.store(new FileOutputStream(STUB_INDEX_DATAFILE), null);
		} catch (Exception e) {
			e.printStackTrace();
			throw new IndexAccessException(e);
		}
		closed = true;
	}

	/**
	 * ݂̃CfbNXt@CɎ荞
	 */
	public void load() throws FileNotFoundException, IOException {
		index = new Properties();
		index.load(new FileInputStream(STUB_INDEX_DATAFILE));
	}
	/**
	 * CfbNXɑ΂čǉ
	 * digest͉p(m[hԍ) + ":" + (hLgԍ)ł邱Ƃz肵Ă<br>
	 * Term[]͍̔z
	 */
	public synchronized void addTerm(String digest, Term[] term) throws IndexAccessException {
		// bZ[W_CWFXg̊mF
		if(digest.indexOf(":") != digest.lastIndexOf(":") || digest.indexOf(":") < 0) {
			throw new IndexAccessException();
		}
		String[] tokens = digest.split(":");
		String nodeId = tokens[0];							// m[hID
		int docno = Integer.parseInt(tokens[1]);			// hLgԍ

		// ʒuAĒǉ
		for(int i = 0; i < term.length; i++) {
			// XV悤ƂĂ̈ʒuɎ擾Ă
			String locations = (String)index.get(term[i].getTerm());
			if(locations == null) {
				locations = "";
			}
			StringBuffer sb = new StringBuffer(locations);

			Term t = term[i];
			for(Iterator it = t.iterator(); it.hasNext();) {
				Integer pos = (Integer)it.next();
				if(sb.length() > 0) {
					sb.append(',');
				}
				sb.append(nodeId + ":" + docno + ":" + pos);
			}

			// 1̈ʒu񂪊̂Ń}bvɓo^
			index.put(t.getTerm(), sb.toString());
		}
	}
	/**
	 * CfbNXVXe폜
	 * @param 폜Ώۂ̍
	 * @return 폜ꂽ̈ʒu
	 */
	public Object removeTerm(String key) throws IndexAccessException {
		return index.remove(key);
	}

	/**
	 * w肳ꂽ̈ʒuCVXẻ񓚂ƂĕԂ
	 * @param key 
	 * @return CfbNXVXeƂẲ(null:ꂪȂ)
	 */
	public KoikeIndexResultSet getValue(String key) throws IndexAccessException {
		String value = (String)index.get(key);

		if(value == null) {
			// ꎩ̂o^ĂȂ
			return null;
		}

		KoikeIndexResultSet rs = new KoikeIndexResultSet();
		// ̈ʒu̓J}؂ł
		String[] values = value.split(",");
		for(int i = 0; i < values.length; i++) {
			String[] tokens = values[i].split(":");
			String nodeId = tokens[0];														// m[hID
			int docno = Integer.parseInt(tokens[1]);										// ԍ
			int pos = Integer.parseInt(tokens[2]);											// ʒu
			int blkno = docno / KoikeConstant.INVERTED_INDEX_BLK_SIZE;						// ubNԍ
			long documents = 1 << docno - (blkno * KoikeConstant.INVERTED_INDEX_BLK_SIZE);	// document availability

			InvertedIndex iidx = rs.getInvertedIndex(nodeId, blkno);
			if(iidx != null) {
				documents = documents | iidx.getDocumentAvailability();
			} else {
				iidx = new InvertedIndex(nodeId, blkno, 0);
			}
			// document availabilityĐݒ肷
			iidx.setDocumentAvailability(documents);
			// ]uCfbNXɑ΂Ĉʒuǉ
			iidx.addLocation(new Location(nodeId, docno, pos));

			rs.addInvertedIndex(iidx);
		}

		// ʂԂ
		return rs;
	}
}
