/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: FullTextSearchApplicationPack.java,v 1.4 2005/12/04 06:09:42 rampil Exp $
 */
package org.logical_paradox.koike.tools.ri;

import java.util.Properties;

import javax.swing.JTextField;

import org.logical_paradox.console.ApplicationPack;
import org.logical_paradox.koike.core.KoikeConfig;
import org.logical_paradox.koike.core.KoikeConstant;
import org.logical_paradox.koike.core.search.Element;
import org.logical_paradox.koike.core.search.ResultSet;
import org.logical_paradox.koike.core.search.SearchCondition;
import org.logical_paradox.koike.core.search.SearchEngine;
import org.logical_paradox.koike.core.search.SearchResult;

/**
 * FullTextSearchApplicationPack
 * SAvP[ṼR\[
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.4 $
 */
public class FullTextSearchApplicationPack extends ApplicationPack {
	/** SGW */
	protected SearchEngine core;

	/**
	 * RXgN^
	 */
	public FullTextSearchApplicationPack() {
		super();
	}
	/**
	 * AvP[V
	 * @throws Exception ȂO
	 */
	public void init() throws Exception {
		Properties p = new Properties();
		// ۃC^[tF[Xt@Ng
		p.setProperty(KoikeConstant.KEY_INTERFACE_FACTORY, "org.logical_paradox.koike.tools.isys.StubConcreteInterfaceFactory");
		// n-gram
		p.setProperty(KoikeConstant.KEY_N_GRAM_TERM_LENGTH, "2");

		KoikeConfig config = new KoikeConfig(p);

		core = new StubSearchEngine(config);
	}
	/**
	 * eLXgtB[hɉ͂ꂽꍇ̃Cxgnh
	 * @param jtf eLXgtB[h
	 * @throws Exception ȂO
	 */
	public void cbTextField(JTextField jtf) throws Exception {
		String[] searchWords = jtf.getText().trim().split(" ");		// pXy[X؂Ō𕪊

		// 𐶐
		SearchCondition condition = new SearchCondition();
		for(int i = 0; i < searchWords.length; i++) {
			condition.addChildNode(new Element(Element.TYPE_TERM, searchWords[i]));
		}
		// 1y[W̕\
		condition.setDispnum(10);
		// \Jnʒu
		condition.setStartp(0);
		double begin = System.currentTimeMillis();
		SearchResult sr = core.search(condition);
		double fin = System.currentTimeMillis();

		double needtime = (fin - begin) / 1000.0;

		ResultSet[] results = null;
		if(sr == null) {
			results = new ResultSet[0];
		} else {
			results = sr.getResultSet();
		}
		jtf.setText("");

		cleanLogView();

		// ʂ̕\
		if(results != null) {
			getWriter().println(":" + needtime);
			getWriter().println("Y: " + results.length);
			for(int i = 0; i < results.length; i++) {
				getWriter().println("(" + (i+1) + "): " + "[" + results[i].getDocumentTitle() + "]");
				getWriter().println("p: " + results[i].getUrl() + " (" + results[i].getNodeId() + ":" + results[i].getDocno() + ")");
				getWriter().println("------------------------------");		// s
				getWriter().println(results[i].getSummary());
				getWriter().println("------------------------------");		// s
			}
		} else {
			getWriter().println("v܂ł");
		}
	}
	/**
	 * AvP[VI
	 * @throws Exception ȂO
	 */
	public void destroy() throws Exception {
		core = null;
	}
}

// end of FullTextSearchApplicationPack.java