/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: ConsolePanel.java,v 1.1 2005/05/31 14:38:20 rampil Exp $
 */
package org.logical_paradox.koike.tools.wf;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

import org.logical_paradox.common.swing.WindowPanel;
import org.logical_paradox.common.util.StringUtils;

/**
 * Pꌟpl
 * ǂɂł\t\
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.1 $
 */
public class ConsolePanel extends WindowPanel implements ActionListener {
	/** P͗ */
	private JTextField wordInputArea;
	/** 팟hLg͗ */
	private JTextArea documentInputArea;
	/** ʕ\ */
	private JTextArea searchResultArea;
	/** usearchv{^ */
	private JButton doSearchButton;

	/**
	 * RXgN^
	 */
	public ConsolePanel() {
		init();
	}

	/**
	 * pl
	 */
	public void init() {
		// pl̍쐬
		JPanel searchPanel = new JPanel();
		searchPanel.setLayout(new BorderLayout());

		JPanel wordPanel = new JPanel();
		wordPanel.setLayout(new BorderLayout());
		wordInputArea = new JTextField();
		doSearchButton = new JButton("search");
		doSearchButton.addActionListener(this);

		wordPanel.add(wordInputArea, BorderLayout.CENTER);
		wordPanel.add(doSearchButton, BorderLayout.EAST);
		// ʏ㕔̒P͗ƌ{^zu
		searchPanel.add(wordPanel, BorderLayout.NORTH);
		// ͓\tzu
		documentInputArea = new JTextArea();
		searchPanel.add(new JScrollPane(documentInputArea), BorderLayout.CENTER);

		// Grid layoutƂ
		setLayout(new GridLayout(2,1));

		searchResultArea = new JTextArea();
		searchResultArea.setEditable(false);

		// plƌʕ\ǉ
		add(searchPanel);
		add(new JScrollPane(searchResultArea));
	}

	/**
	 * {^̃Cxgnh
	 * @param e CxgIuWFNg
	 */
	public void actionPerformed(ActionEvent e) {
		String word = wordInputArea.getText();
		String document = documentInputArea.getText();

		if(StringUtils.isEmpty(word) && StringUtils.isEmpty(document)) {
			return;
		}

		Integer[] pos = StringUtils.searchWordIndexes(document, word);

		StringBuffer sb = new StringBuffer(":\n\n");
		if(pos == null || pos.length == 0) {
			sb.append("YȂ");
		} else {
			for(int i = 0; i < pos.length; i++) {
				sb.append(pos[i].toString() + "\n");
			}
		}

		wordInputArea.setText("");
		searchResultArea.setText(sb.toString());
	}
}
