/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.koike.rss.tools.docb;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logical_paradox.common.swing.WindowPanel;
import org.logical_paradox.koike.rss.tools.DataSourceException;
import org.logical_paradox.koike.rss.tools.docb.BrowserProperties;
import org.logical_paradox.koike.rss.tools.docb.Query;
import org.logical_paradox.koike.rss.tools.docb.Select;

public class DocumentBrowserPanel
extends WindowPanel
implements ActionListener {
    private static final Log log;
    public JTextField url;
    public JTextField docno;
    public JTextArea document;
    public JButton btnSearch;
    public JButton btnClear;
    private Select select;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.logical_paradox.koike.rss.tools.docb.DocumentBrowserPanel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public DocumentBrowserPanel() {
        this.init();
    }

    protected void init() {
        this.setLayout(new BorderLayout());
        JPanel searchControlPanel = new JPanel();
        searchControlPanel.setBorder(BorderFactory.createTitledBorder("search condition"));
        searchControlPanel.setLayout(new BoxLayout(searchControlPanel, 0));
        this.url = new JTextField();
        this.url.setColumns(30);
        this.docno = new JTextField();
        this.docno.setColumns(10);
        searchControlPanel.add(new JLabel("  URL : "));
        searchControlPanel.add(this.url);
        searchControlPanel.add(new JLabel("  docno : "));
        searchControlPanel.add(this.docno);
        this.btnSearch = new JButton("retrieve");
        this.btnSearch.addActionListener(this);
        searchControlPanel.add(this.btnSearch);
        this.document = new JTextArea();
        this.document.setEditable(false);
        this.document.setLineWrap(true);
        JScrollPane documentPane = new JScrollPane(this.document);
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new BorderLayout());
        this.btnClear = new JButton("clear");
        this.btnClear.addActionListener(this);
        controlPanel.add((Component)this.btnClear, "East");
        this.add(searchControlPanel, "North");
        this.add(documentPane, "Center");
        this.add(controlPanel, "South");
        this.validate();
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btnClear) {
            this.document.setText("");
        } else if (e.getSource() == this.btnSearch) {
            log.trace((Object)"\u691c\u7d22\u51e6\u7406\u3092\u958b\u59cb\u3057\u307e\u3059");
            if (this.select == null) {
                try {
                    this.select = (Select)Class.forName(BrowserProperties.getProperty("select.class")).newInstance();
                    this.select.open(BrowserProperties.getProperty("select.param.init"));
                }
                catch (Exception ex) {
                    log.error((Object)"\u30c9\u30ad\u30e5\u30e1\u30f3\u30c8\u30bb\u30ec\u30af\u30bf\u306e\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u5316\u306b\u5931\u6557:", (Throwable)ex);
                }
            }
            Query q = new Query();
            String digest = this.url.getText();
            int cid = -1;
            try {
                if (this.docno.getText() != null && this.docno.getText().trim().length() > 0) {
                    cid = Integer.parseInt(this.docno.getText());
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            q.setUrl(digest);
            q.setDocno(cid);
            try {
                String contents = this.select.executeQuery(q);
                if (contents == null) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "contents not found", "inquiry error", 0);
                } else {
                    log.trace((Object)contents);
                    this.document.setText(contents);
                }
            }
            catch (DataSourceException dse) {
                log.error((Object)"\u4f55\u3089\u304b\u306e\u7406\u7531\u3067\u7167\u4f1a\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f:", (Throwable)dse);
            }
        }
    }

    public void close() {
        log.trace((Object)"\u7d42\u4e86\u51e6\u7406\u3092\u958b\u59cb\u3057\u307e\u3059");
        if (this.select != null) {
            try {
                this.select.close();
            }
            catch (DataSourceException e) {
                log.warn((Object)"\u30c7\u30fc\u30bf\u30bd\u30fc\u30b9\u3068\u306e\u63a5\u7d9a\u7d42\u4e86\u51e6\u7406\u4e2d\u306b\u4f8b\u5916\u304c\u767a\u751f:", (Throwable)e);
            }
        }
        log.trace((Object)"\u7d42\u4e86\u51e6\u7406\u3092\u5b8c\u4e86\u3057\u307e\u3057\u305f");
    }
}

