/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.koike.rss.tools.docb.impl;

import java.sql.Blob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logical_paradox.koike.rss.tools.DataSourceException;
import org.logical_paradox.koike.rss.tools.docb.Query;
import org.logical_paradox.koike.rss.tools.docb.Select;
import org.logical_paradox.rss.rcm.df.DataFilter;
import org.logical_paradox.rss.rcm.df.DataFilterFactory;

public class MySQLSelect
implements Select {
    public static final String JDBC_DRIVER = "com.mysql.jdbc.Driver";
    public static final String QUERY_BY_URL = "SELECT contents FROM contents WHERE mkey=?";
    public static final String QUERY_BY_DOCNO = "SELECT contents FROM contents WHERE cid=?";
    private static final Log log;
    private Connection con;
    private DataFilter filter = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.logical_paradox.koike.rss.tools.docb.impl.MySQLSelect");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public void open(String connstr) throws DataSourceException {
        try {
            Class.forName(JDBC_DRIVER);
            this.con = DriverManager.getConnection(connstr);
            this.filter = DataFilterFactory.getFilter((int)1);
        }
        catch (Exception e) {
            log.error((Object)"JDBC\u30c9\u30e9\u30a4\u30d0\u306e\u30ed\u30fc\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f:", (Throwable)e);
            throw new DataSourceException(e);
        }
    }

    public void close() throws DataSourceException {
        block4: {
            if (this.con == null) break block4;
            try {
                try {
                    this.con.close();
                }
                catch (SQLException sQLException) {}
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                this.con = null;
                throw throwable;
            }
            Object var2_4 = null;
            this.con = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String executeQuery(Query q) throws DataSourceException {
        log.trace((Object)"\u30b3\u30f3\u30c6\u30f3\u30c4\u3092\u7167\u4f1a\u3057\u3066\u3044\u307e\u3059");
        String url = q.getUrl();
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String contents = null;
        try {
            try {
                if (url != null && url.trim().length() > 0) {
                    pstmt = this.con.prepareStatement(QUERY_BY_URL);
                    pstmt.setString(1, this.filter.filterURL(url));
                    log.debug((Object)QUERY_BY_URL);
                } else {
                    pstmt = this.con.prepareStatement(QUERY_BY_DOCNO);
                    pstmt.setInt(1, q.getDocno());
                    log.debug((Object)QUERY_BY_DOCNO);
                }
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    log.trace((Object)"\u30b3\u30f3\u30c6\u30f3\u30c4\u306e\u7167\u4f1a\u5b8c\u4e86\uff0e\u30b3\u30f3\u30c6\u30f3\u30c4\u3092\u30c7\u30b3\u30fc\u30c9\u3057\u3066\u3044\u307e\u3059");
                    Blob blob = rs.getBlob("contents");
                    byte[] bstream = blob.getBytes(1L, (int)blob.length());
                    contents = new String(this.filter.decompressContents(bstream));
                }
                log.trace((Object)"\u5b8c\u4e86\uff0e");
                String string = contents;
                Object var8_10 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (pstmt == null) return string;
                    pstmt.close();
                    return string;
                }
                catch (SQLException e) {
                    // empty catch block
                }
                return string;
            }
            catch (Exception e) {
                throw new DataSourceException(e);
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            try {}
            catch (SQLException e) {
                throw throwable;
            }
            if (rs != null) {
                rs.close();
            }
            if (pstmt == null) throw throwable;
            pstmt.close();
            throw throwable;
        }
    }
}

