/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.rss.rcm.accessor.mysql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.StackObjectPool;

public class DbConnection {
    private static ObjectPool pool = new StackObjectPool();
    private static DataSource ds;
    private static HashMap map;

    private DbConnection() {
    }

    public static final synchronized void init(String connstr) throws Exception {
        Class.forName("com.mysql.jdbc.Driver").newInstance();
        DriverManagerConnectionFactory factory = new DriverManagerConnectionFactory(connstr, new Properties());
        new PoolableConnectionFactory((ConnectionFactory)factory, pool, null, null, false, true);
        ds = new PoolingDataSource(pool);
    }

    public static final synchronized Connection getConnection() throws SQLException {
        String key = Thread.currentThread().getName();
        ArrayList<Connection> leasedConnections = (ArrayList<Connection>)map.get(key);
        if (leasedConnections == null) {
            leasedConnections = new ArrayList<Connection>();
        }
        Connection con = ds.getConnection();
        leasedConnections.add(con);
        map.put(key, leasedConnections);
        return con;
    }

    public static final synchronized void close() {
        String key = Thread.currentThread().getName();
        List leasedConnections = (List)map.get(key);
        if (leasedConnections == null) {
            return;
        }
        Iterator it = leasedConnections.iterator();
        while (it.hasNext()) {
            Connection con = (Connection)it.next();
            try {
                con.close();
            }
            catch (SQLException se) {}
        }
        leasedConnections.clear();
        map.remove(key);
    }

    public static final synchronized void close(Connection con) {
        if (con == null) {
            return;
        }
        try {
            con.close();
        }
        catch (SQLException se) {
            // empty catch block
        }
        String key = Thread.currentThread().getName();
        List leasedConnections = (List)map.get(key);
        if (leasedConnections == null) {
            return;
        }
    }

    public static final synchronized void shutdown() {
        Iterator keys = map.keySet().iterator();
        while (keys.hasNext()) {
            String key = keys.next().toString();
            List leasedConnections = (List)map.get(key);
            if (leasedConnections == null) continue;
            Iterator it = leasedConnections.iterator();
            while (it.hasNext()) {
                Connection con = (Connection)it.next();
                if (con == null) continue;
                try {
                    con.close();
                }
                catch (SQLException se) {}
            }
            leasedConnections.clear();
        }
        map.clear();
    }

    static {
        map = new HashMap();
    }
}

