/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.common.vrm;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.logical_paradox.common.io.ByteStream;

public abstract class Record
implements ByteStream,
Comparable {
    protected ByteStream o;

    public Record() {
    }

    public Record(byte[] bstream) {
        this.byteStreamToObject(bstream);
    }

    public Record(ByteStream stream) {
        this.o = stream;
    }

    public void setObject(ByteStream b) {
        this.o = b;
    }

    public Object getObject() {
        return this.o;
    }

    public byte[] getObjectByteStream() {
        return this.o.byteStream();
    }

    public int size() {
        return this.byteStream().length;
    }

    public byte[] byteStream() {
        byte[] bstream = this.o.byteStream();
        ByteBuffer buffer = ByteBuffer.allocate(4 + bstream.length).order(ByteOrder.BIG_ENDIAN);
        buffer.putInt(bstream.length);
        buffer.put(bstream);
        return buffer.array();
    }

    protected void byteStreamToObject(byte[] bstream) throws IllegalArgumentException {
        ByteBuffer buffer = ByteBuffer.allocate(bstream.length).order(ByteOrder.BIG_ENDIAN);
        buffer.put(bstream);
        ((Buffer)buffer).rewind();
        try {
            byte[] object = new byte[bstream.length];
            buffer.get(object);
            this.createObjectFromByteStream(object);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public int compareTo(Object o) {
        Record r = (Record)o;
        if (this.size() < r.size()) {
            return -1;
        }
        if (this.size() > r.size()) {
            return 1;
        }
        return 0;
    }

    public abstract int getRecordSize();

    public abstract boolean equals(Object var1);

    protected abstract void createObjectFromByteStream(byte[] var1) throws IllegalArgumentException;
}

