/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.common.vrm;

import java.util.Hashtable;
import org.logical_paradox.common.vrm.Record;

public abstract class RecordFactory {
    public static final String DEFAULT_RECORD_FACTORY_CLASS_NAME = "org.logical_paradox.common.vrm.DefaultRecordFactory";
    public static final String DEFAULT_RECORD_FACTORY_PROPERTY_NAME = "org.logical_paradox.common.vrm.RecordFactoryClass";
    private static final Hashtable factoryPool = new Hashtable();

    protected RecordFactory() {
    }

    public static final RecordFactory getInstance() throws Exception {
        return RecordFactory.getInstance(DEFAULT_RECORD_FACTORY_CLASS_NAME);
    }

    public static final RecordFactory getInstance(String classname) throws Exception {
        RecordFactory factory = (RecordFactory)factoryPool.get(classname);
        if (factory != null) {
            return factory;
        }
        factory = (RecordFactory)Class.forName(classname).newInstance();
        factoryPool.put(classname, factory);
        return factory;
    }

    public abstract Record getRecord(byte[] var1);
}

