/*
 * $Id: ServiceList.java,v 1.10 2006/02/06 15:32:50 rampil Exp $
 * Copyright (c) 2005 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.rss.dsr;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;

import org.logical_paradox.rss.Service;
import org.logical_paradox.rss.dsr.algorithm.ServiceBindingAlgorithm;

/**
 * ServiceList
 * T[rX̂̃Xg
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.10 $
 */
public class ServiceList {
	/** T[rX̃Xg */
	protected final Hashtable<String, Service> list;
	/** T[rX蓖Ă̂߂̃ASY */
	protected final ServiceBindingAlgorithm bindingAlgorithm;

	/**
	 * RXgN^D
	 * @param ba T[rXoCfBOASY
	 */
	public ServiceList(ServiceBindingAlgorithm ba) {
		list = new Hashtable<String, Service>();
		bindingAlgorithm = ba;
	}

	/**
	 * I\ȃ[gT[rXǉD
	 * @param name m[hID
	 * @param JꂽT[rX̃X^u
	 */
	public void add(String name, Service stub) {
		list.put(name, stub);
	}

	/**
	 * I\ȃ[gT[rX폜(T[rX~ꍇȂ)D
	 * @param name m[hID
	 */
	public void remove(String name) {
		list.remove(name);
	}

	/**
	 * I\ȃ[gT[rX̃Ce[^ԂD
	 * @return T[rX̃Xg|CgĂCe[^
	 */
	public Iterator<String> iterator() {
		return list.keySet().iterator();
	}

	/**
	 * i[ĂT[rX̃m[hID̃XgԂ
	 * @return m[hID̃Xg
	 */
	public String[] serviceNames() {
		synchronized(list) {
			return list.keySet().toArray(new String[0]);
		}
	}

	/**
	 * w肳ꂽ̂̃T[rXo^Ă邩ǂԂ
	 * @param serviceName m[hID
	 * @return true: / false:Ȃ
	 */
	public boolean contains(String serviceName) {
		return list.containsKey(serviceName);
	}

	/**
	 * i[ĂT[rX̃XgCK؂ȃT[rX̃X^uIĕԂ
	 * @return IꂽT[rX
	 */
	public Service getService() {
		String serviceName = bindingAlgorithm.getService(this);
		if(serviceName != null) {
			return list.get(serviceName);
		} else {
			return null;
		}
	}

	/**
	 * i[ĂT[rX̃XgCK؂ȃT[rX̃X^uIĕԂ
	 * @param serviceName T[rX
	 * @return IꂽT[rX
	 */
	public Service getService(String serviceName) {
		Service service = list.get(serviceName);
		return service;
	}
	/**
	 * i[ĂSẴT[rXԂ
	 * @return SẴT[rX
	 */
	public Collection<Service> values() {
		return list.values();
	}
}
