/*
 * $Id: RSSHttpResponse.java,v 1.5 2006/02/06 15:32:50 rampil Exp $
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 *
 */
package org.logical_paradox.rss.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;

import HTTPClient.HTTPResponse;
import HTTPClient.ModuleException;

/**
 * RSS/1bpHTTPX|XIuWFNgD<br>
 * HTTPClientNXZbǵCHTTPResponsebsOĂ܂
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.5 $
 */
public class RSSHttpResponse {
	/** Rec̕\ */
	private String contentAsString;
	/** X|X */
	private HTTPResponse _resp;
	/** GR[fBO` */
	private String _encodingType;


	/**
	 * RXgN^D
	 * @param r X|XIuWFNg
	 * @param encodingType GR[fBO`
	 */
	public RSSHttpResponse(HTTPResponse r, String encodingType) {
		_resp = r;
		_encodingType = encodingType;
	}
	/**
	 * GR[fBO`ԂD
	 * @return GR[fBO`
	 */
	public String getEncodingType() {
		return _encodingType;
	}
	/**
	 * X|XR[hԂD
	 * @return X|XR[h
	 */
	public int getResponseCode() {
		int rc = 0;
		try {
			rc = _resp.getStatusCode();
		} catch(Exception e) {
			rc = -1;
		}
		return rc;
	}
	/**
	 * X|XR[h̕\ԂD
	 * @return X|XR[h̕\
	 */
	public String getResponseMessage() {
		String s = null;
		try {
			s = _resp.getReasonLine();
		} catch(Exception e) {
			s = null;
		}

		return s;
	}
	/**
	 * Reĉ̂ԂD
	 * @return Rec
	 * @throws IOException 擾Ɏs
	 * @throws ModuleException 悭킩ȂRŎs
	 */
	public String getText() throws IOException, ModuleException {
		if(contentAsString == null) {
			InputStream in = _resp.getInputStream();
			if(in == null) {
				return "";
			}

			// HTML\[Xunicodeɕϊǂݎ
			BufferedReader reader = new BufferedReader(new InputStreamReader(in, "JISAutoDetect"));
			String line = "";
			StringBuffer buf = new StringBuffer();
			while((line = reader.readLine()) != null) {
				buf.append(line);
			}
			reader.close();

			// ŌɎw肳ꂽGR[fBOɕϊďo͂
			contentAsString = new String(buf.toString());//.getBytes("8859_1"), _encodingType);
		}

		return contentAsString;
	}
	/**
	 * Rec̑oCgԂD
	 * @return oCg
	 */
	public int getContentLength() {
		if(contentAsString == null) {
			return 0;
		} else {
			return contentAsString.length();
		}
	}
	/**
	 * Content-TypeԂD
	 * @return Content-Type
	 */
	public String getContentType() {
		String s = null;
		try {
			s = _resp.getHeader("Content-Type");
		} catch(Exception e) {
			s = null;
		}

		return s;
	}
	/**
	 * ŏIIɊm肵URLԂD
	 * @return ŏIIɊm肵URL(Locationwb_ɂforwardȂǂ̓])
	 */
	public URL getEffectiveURL() {
		URL u = null;
		try {
			u = _resp.getEffectiveURI().toURL();
		} catch(Exception e) {
			u = null;
		}
		return u;
	}
	/**
	 * NGXgURLԂD
	 * @return NGXgURL
	 */
	public URL getURL() {
		URL u = null;
		try {
			u = _resp.getOriginalURI().toURL();
		} catch(Exception e) {
			u = null;
		}
		return u;
	}
	/**
	 * HTTPX|Xwb_̃L[ԂD
	 * @return HTTPX|Xwb_
	 */
	public Enumeration getHeaderKeys() {
		Enumeration e = null;
		try {
			e = _resp.listHeaders();
		} catch(Exception ioe) {
			e = null;
		}
		return e;
	}
	/**
	 * wL[ɑΉHTTPX|Xwb_lԂD
	 * @param key wb_
	 * @return HTTPX|Xwb_l
	 */
	public String getHeader(String key) {
		String s = null;
		try {
			s = _resp.getHeader(key);
		} catch(Exception e) {
			s = null;
		}
		return s;
	}
}
