/*
 * $Id: RSSHttpURLConnectionFactory.java,v 1.3 2005/10/23 12:31:35 rampil Exp $
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 *
 */
package org.logical_paradox.rss.http;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

import HTTPClient.ModuleException;
import HTTPClient.ProtocolNotSuppException;

/**
 * HTTPڑIuWFNgt@Ng
 * ɃeXgp̃X^u𐶐邽
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.3 $
 */
public class RSSHttpURLConnectionFactory {
	/** [JzXg */
	public static final String LOCALHOST = "localhost";
	/** HTTP|[gԍ */
	public static final int HTTP_PORT = 80;

	/** ݂̃[JzXgݒ */
	private static String localhostSetting = LOCALHOST;
	/** ݂̃|[gԍݒ */
	private static int httpPort = HTTP_PORT;
	/** X^up̃C^[tF[XԂǂ */
	private static boolean stub = false;

	/**
	 * eXg[hǂݒ肷D
	 * eXg[hƂꍇCǂURL^ĂlocalhostɕϊĐڑD
	 * @param m eXg[h(true:eXg[h / false:{ԃ[h)
	 */
	public static void enableTestMode(boolean m) {
		stub = m;
	}
	/**
	 * ftHg̐ڑݒ肷D
	 * @param hostname zXg(eXgphttpdNĂzXg)
	 * @param port |[gԍ(ʏ80, eXgphttpdlisteningĂ|[gԍ)
	 */
	public static final void setLocalhostSetting(String hostname, int port) {
		localhostSetting = hostname;
		httpPort = port;
	}
	/**
	 * ڑIuWFNg𐶐ĕԂD
	 * ɎIɐڑD
	 * @param dest ڑ
	 * @return ꂽڑIuWFNg
	 * @throws ProtocolNotSuppException ȃvgRT|[gĂ܂
	 */
	public static final RSSHttpURLConnection getConnection(URL dest) throws ProtocolNotSuppException, MalformedURLException {
		if(stub == false) {
			// {ԗp
			return new RSSHttpURLConnection(dest);
		} else {
			// eXgp
			return new RSSHttpURLConnectionStub(dest, localhostSetting, httpPort);
		}
	}
	/**
	 * X|XIuWFNg𐶐ĕԂD
	 * @param con HTTPX|XIuWFNg
	 * @param encoding GR[fBO`
	 * @return ꂽX|XIuWFNg
	 */
	public static final RSSHttpResponse getResponse(RSSHttpURLConnection con, String encoding) throws IOException, ModuleException {
		RSSHttpResponse res = null;
		if(stub == false) {
			res = new RSSHttpResponse(con.get(), encoding);
		} else {
			res = new RSSHttpResponseStub(con.get(), encoding, con.getURL());
		}

		return res;
	}
}
