/*
 * $Id: URLSuspender.java,v 1.3 2006/01/27 14:20:44 rampil Exp $
 * Copyright (c) 2006 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.rss.http;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

/**
 * URLSuspender
 * TꎞIɗ}ĂTCgǗNX
 * TCg̃NXɓo^ĂꍇCT}ΏۂƂȂ
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.3 $
 */
public class URLSuspender {
	/** T}}bv */
	private Hashtable<String, URLSuspendedSite> sites = null;

	/**
	 * RXgN^D
	 */
	public URLSuspender() {
		sites = new Hashtable<String, URLSuspendedSite>();
	}

	/**
	 * wTCg̒T}D
	 * @param s TCg
	 * @param url URL
	 * @throws IllegalArgumentException TCg񂪕s
	 */
	public void suspend(Site s, String url) throws IllegalArgumentException {
		if(s == null || s.getSiteName() == null) {
			throw new IllegalArgumentException();
		}

		URLSuspendedSite site = null;
		synchronized(sites) {
			site = (URLSuspendedSite)sites.get(s.getSiteName());
			if(site == null) {
				site = new URLSuspendedSite(s);
			}
			site.add(url);
		}

		sites.put(s.getSiteName(), site);
	}

	/**
 	 * wTCgɑΉTCgIuWFNgԂD
 	 * @param hC(TCg)
 	 * @return TCg
	 */
	public Site get(String sn) {
		URLSuspendedSite s = (URLSuspendedSite)sites.get(sn);
		if(s == null) {
			return null;
		} else {
			return s.getSite();
		}
	}

	/**
	 * wTCgT}Ă邩ǂԂD
	 * @param s hC(TCg)
	 * @return true: }Ă / false: }ĂȂ
	 */
	public boolean isSuspended(String s) {
		if(s == null) {
			throw new IllegalArgumentException();
		}

		boolean rc = false;
		synchronized(sites) {
			if(sites.get(s) == null) {
				// wTCgꗗɑ݂Ȃꍇ͗}ĂȂ
				rc = false;
			} else {
				// wTCgꗗɑ݂ꍇ͗}Ă
				rc = true;
			}
		}

		return rc;
	}

	/**
	 * wTCgT}Ă邩ǂԂD
	 * @param s TCg
	 * @return true: }Ă / false: }ĂȂ
	 * @throws IllegalArgumentException TCg񂪕s
	 */
	public boolean isSuspended(Site s) throws IllegalArgumentException {
		if(s == null) {
			throw new IllegalArgumentException();
		}

		return isSuspended(s.getSiteName());
	}

	/**
	 * wTCg̒T}D
	 * ہC}ԂɒuĂURLSĕԂ
	 * @param s hC(TCg)
	 * @return }ԂURL̔z
	 * @throws IllegalArgumentException TCgs
	 */
	public String[] release(String s) throws IllegalArgumentException {
		if(s == null) {
			throw new IllegalArgumentException();
		}

		URLSuspendedSite us = (URLSuspendedSite)sites.get(s);
		if(us == null) {
			return null;
		}

		// wTCg}Ԃɂꍇ́CURLSĕԂ
		String[] urls = us.releaseAll();
		sites.remove(s);

		return urls;
	}

	/**
	 * wTCg̒T}D
	 * ہC}ԂɒuĂURLSĕԂ
	 * @param s TCg
	 * @return }ԂURL̔z
	 * @throws IllegalArgumentException TCg񂪕s
	 */
	public String[] release(Site s) throws IllegalArgumentException {
		if(s == null) {
			throw new IllegalArgumentException();
		}

		return release(s.getSiteName());
	}

	/**
	 * i[ĂURL̐ԂD
	 * @return URL
	 */
	public int size() {
		int urls = 0;
		synchronized(sites) {
			Enumeration e = sites.elements();
			while(e.hasMoreElements()) {
				urls += ((URLSuspendedSite)e.nextElement()).size();
			}
		}
		return urls;
	}

	/**
	 * T}ĂTCgƂɑURLi[ReiD
	 * @author satoshi akabane@logical-paradox.org
	 * @version $Revision: 1.3 $
	 */
	class URLSuspendedSite {
		private Site site = null;
		private HashSet<String> urls = null;

		// RXgN^
		private URLSuspendedSite(Site s) {
			site = s;
			urls = new HashSet<String>();
		}
		// URLǉ
		private void add(String url) {
			urls.add(url);
		}
		// URL폜
		private void remove(String url) {
			urls.remove(url);
		}
		// w肳ꂽURL}ԂŊi[Ă邩ǂԂ
		private boolean isContained(String url) {
			return urls.contains(url);
		}
		// ̃TCg̒T}URL̑Ԃ
		private int size() {
			return urls.size();
		}
		// TCgIuWFNgԂ
		private Site getSite() {
			return site;
		}
		// SĂURL
		private String[] releaseAll() {
			Vector<String> list = new Vector<String>();
			synchronized(urls) {
				Iterator i = urls.iterator();
				while(i.hasNext()) {
					list.addElement(i.next().toString());
				}

				// o^ĂSĂURL폜
				urls.removeAll(urls);
			}

			return (String[])list.toArray(new String[1]);
		}
	}
}

// end of URLSuspender.java
