/*
 * $Id: WebContents.java,v 1.5 2006/01/26 16:27:34 rampil Exp $
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 *
 */
package org.logical_paradox.rss.http;
import java.io.Serializable;
import java.net.URL;

/**
 * WebContents
 * T[o[_E[hĂEFuRecۗL邽߂̃IuWFNg
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.5 $
 */
public class WebContents implements Serializable {
	/** VAo[WUID */
	private static final long serialVersionUID = -4901655369957216355L;

	/** ϊÕhLg */
	private String originalDocument;
	/** hLg */
	private String document;
	/** hLg^Cg */
	private String title;
	/** hLg\[Ẍʒu(URLȂ) */
	private String location;
	/** TCg */
	private String sitename;
	/** Recmime-type */
	private String contentType;
	/** HTTPXe[^XR[h */
	private int responseCode;
	/** RecURL */
	private URL url;

	/** robots.txtǂ(true: / false:Ⴄ) */
	private boolean robotsTxtFlg = false;

	/**
	 * RXgN^D
	 */
	public WebContents() {
	}

	/**
	 * X|XR[hԂD
	 * @return HTTPXe[^XR[h
	 */
	public int getResponseCode() {
		return responseCode;
	}

	/**
	 * Rec̑傫ԂD
	 * IWĩRec̃TCYԂD
	 */
	public int getContentLength() {
		return originalDocument.length();
	}
	/**
	 * ϊÕhLgԂD
	 * @return ϊÕhLg
	 */
	public String getOriginalDocument() {
		return originalDocument;
	}

	/**
	 * Rec̎ނԂD
	 * @return Rec̎(mime-type)
	 */
	public String getContentType() {
		return contentType;
	}

	/**
	 * hLgԂD
	 * @return hLg
	 */
	public String getDocument() {
		return document;
	}

	/**
	 * hLg\[ẌʒuԂD
	 * @return hLg\[Ẍʒu(URLȂ)
	 */
	public String getLocation() {
		return location;
	}

	/**
	 * TCgԂD
	 * @return TCg
	 */
	public String getSitename() {
		return sitename;
	}

	/**
	 * hLg^CgԂD
	 * @return hLg^Cg
	 */
	public String getTitle() {
		return title;
	}

	/**
	 * hLgݒ肷D
	 * @param string hLg
	 */
	public void setDocument(String string) {
		document = string;
	}

	/**
	 * hLg\[Ẍʒuݒ肷D
	 * @param string hLg\[Ẍʒu(URLȂ)
	 */
	public void setLocation(String string) {
		location = string;
	}

	/**
	 * TCgݒ肷D
	 * @param string TCg
	 */
	public void setSitename(String string) {
		sitename = string;
	}

	/**
	 * hLg^Cgݒ肷D
	 * @param string hLg^Cg
	 */
	public void setTitle(String string) {
		title = string;
	}

	/**
	 * ϊÕhLgݒ肷D
	 * @param ori ϊÕhLg
	 */
	public void setOriginalDocument(String ori) {
		originalDocument = ori;
	}

	/**
	 * hLg̒ԂD
	 * @return hLg̒
	 */
	public int length() {
		return document == null ? 0 : document.length();
	}

	/**
	 * robots.txtǂԂD
	 * @return true: / false:Ⴄ
	 */
	public boolean isRobotsTxtFlg() {
		return robotsTxtFlg;
	}

	/**
	 * mime^Cvݒ肷D
	 * @param string mime^Cv
	 */
	public void setContentType(String string) {
		contentType = string;
	}

	/**
	 * HTTPXe[^XR[hݒ肷D
	 * @param i httpXe[^XR[h
	 */
	public void setResponseCode(int i) {
		responseCode = i;
	}

	/**
	 * robots.txtǂԂD
	 * @param b true: / false:Ⴄ
	 */
	public void setRobotsTxtFlg(boolean b) {
		robotsTxtFlg = b;
	}

	/**
	 * RecURLԂD
	 * @return RecURL
	 */
	public URL getURL() {
		return url;
	}

	/**
	 * RecURLݒ肷D
	 * @param u RecURL
	 */
	public void setURL(URL u) {
		url = u;
	}
}
