/*
 * $Id: RSSLCConfig.java,v 1.9 2006/02/21 14:54:48 akabane Exp $
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2006 satoshi akabane(akabane@logical-paradox.org)
 *
 */
package org.logical_paradox.rss.lcmgr;

import java.io.IOException;
import java.util.LinkedList;

import org.logical_paradox.rss.RSSConfig;
import org.logical_paradox.rss.RSSIllegalConfigException;
import org.logical_paradox.rss.RSSNullValueException;
import org.logical_paradox.rss.RSSValueFormatException;
import org.logical_paradox.rss.http.WebContents;
import org.logical_paradox.rss.rcm.ContentsRegister;

/**
 * RSSLCConfig
 * [JRecǗVXe̐ݒۊǂIuWFNg
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.9 $
 */
public class RSSLCConfig extends RSSConfig {
	public int memCacheSize = 0;														// ɃLbVĂRec̃TCY
	public ContentsRegister cr = null;													// Reco^p̃NCAgIuWFNg
	public LinkedList<WebContents> memCache = new LinkedList<WebContents>();			// ̃RecLbV
	public LinkedList<CacheFileEntry> fileEntries = new LinkedList<CacheFileEntry>();	// t@CGg
	public int nextno = 0;																// ̃RecID(̃XbhŋL)

	public boolean runningStatus = true;

	private String cfgRssDsr = "";
	private String cfgContentsConnStr = "";
	private String cfgContentsAccessor = "";
	private String cfgContentsCacheDir = "cache";
	private boolean cfgLcMgrSwRunLog = false;
	private String cfgLcMgrRunLogFilename = "rsslcmgr.run.log";
	private int cfgContentsSendingMgrs = 5;
	private int cfgContentsSendingInterval = 100;
	private int cfgContentsSendingScale = 256;
	/** Rec̃GR[fBO */
	private String cfgContentsEncoding;

	/**
	 * ڑDSRԂD
	 * @return ڑDSR
	 */
	public String getRssDsr() {
		return cfgRssDsr;
	}
	/**
	 * Rec̃GR[fBOԂD
	 * ݒ肳Ă΂Cݒ肳ĂȂꍇ̓VXeGR[fBOԂD
	 * @return Rec̃GR[fBO
	 */
	public String getContentsEncoding() {
		return cfgContentsEncoding != null ? cfgContentsEncoding : System.getProperty("file.encoding");
	}
	public String getContentsConnStr() {
		return cfgContentsConnStr;
	}
	public String getContentsCacheDir() {
		return cfgContentsCacheDir;
	}
	public boolean getLcMgrSwRunLog() {
		return cfgLcMgrSwRunLog;
	}
	public String getLcMgrRunLogFilename() {
		return cfgLcMgrRunLogFilename;
	}
	public int getContentsSendingMgrs() {
		return cfgContentsSendingMgrs;
	}
	public int getContentsSendingInterval() {
		return cfgContentsSendingInterval;
	}
	public int getContentsSendingScale() {
		return cfgContentsSendingScale;
	}
	public String getContentsAccessor() {
		return cfgContentsAccessor;
	}

	/**
	 * RXgN^
	 */
	public RSSLCConfig( String fn ) throws IOException, RSSIllegalConfigException {
		super( fn );
		String errmsg = checkResourceVariables();
		if( errmsg != null ) {
			throw new RSSIllegalConfigException( errmsg );
		}

		runningStatus = true;
	}

	/**
	 * p[^mF\bh
	 */
	@Override
	protected String checkResourceVariables() {
		String errmsg = "";

		cfgRssDsr = getProperty( "RSS_DSR" );

		cfgContentsCacheDir = getProperty( "CONTENTS_CACHE_DIR" );
		if( cfgContentsCacheDir == null ) {
			errmsg += "CONTENTS_CACHE_DIRw肳Ă܂\n";
		}

		try {
			cfgLcMgrSwRunLog = getPropertyAsBool( "LCMGR_SW_RUNLOG" );
		} catch( RSSValueFormatException vfe ) {
			errmsg += "LCMGR_SW_RUNLOG̒lsł\n";
		} catch( RSSNullValueException ne ) {}

		cfgLcMgrRunLogFilename = getProperty( "LCMGR_RUNLOG_FILENAME" );

		try {
			cfgContentsSendingMgrs = getPropertyAsInt( "CONTENTS_SENDING_MGRS" );
		} catch( RSSValueFormatException vfe ) {
			errmsg += "CONTENTS_SENDING_MGRS̒lsł\n";
		} catch( RSSNullValueException ne ) {}

		cfgContentsConnStr = getProperty( "CONTENTS_CONNSTR" );

		try {
			cfgContentsSendingInterval = getPropertyAsInt( "CONTENTS_SENDING_INTERVAL" );
		} catch( RSSValueFormatException vfe ) {
			errmsg += "CONTENTS_SENDING_INTERVAL̒lsł\n";
		} catch( RSSNullValueException ne ) {}

		try {
			cfgContentsSendingScale = getPropertyAsInt( "CONTENTS_SENDING_SCALE" );
		} catch( RSSValueFormatException vfe ) {
			errmsg += "CONTENTS_SENDING_SCALE̒lsł\n";
		} catch( RSSNullValueException ne ) {}

		cfgContentsEncoding = getProperty("CONTENTS_ENCODING");

		if( errmsg.trim().length() > 0 ) {
			return errmsg;
		} else {
			return null;
		}
	}
}

// end of RSSLCConfig.java
