/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 * $Id: StandAloneContentsRegister.java,v 1.7 2006/02/21 14:54:48 akabane Exp $
 */
package org.logical_paradox.rss.lcmgr;

import static org.logical_paradox.rss.rcm.accessor.ContentsAccessorFactory.PARAM_ACCESSOR_CLASSNAME;
import static org.logical_paradox.rss.rcm.accessor.ContentsAccessorFactory.PARAM_CONTENTS_ENCODING;
import static org.logical_paradox.rss.rcm.accessor.ContentsAccessorFactory.PARAM_DSR_URI;
import static org.logical_paradox.rss.rcm.accessor.ContentsAccessorFactory.PARAM_INIT_PARAM;

import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logical_paradox.common.util.ExceptionUtils;
import org.logical_paradox.rss.http.WebContents;
import org.logical_paradox.rss.rcm.ContentsRegister;
import org.logical_paradox.rss.rcm.accessor.ContentsAccessor;
import org.logical_paradox.rss.rcm.accessor.ContentsAccessorFactory;
import org.logical_paradox.rss.util.RandomKeyGenerator;

/**
 * StandAloneContentsRegister
 * X^hA[ł̃Reco^NCAgIuWFNgD
 * 
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.7 $
 */
public class StandAloneContentsRegister implements ContentsRegister {
	/** K[ */
	private static final Log log = LogFactory.getLog(StandAloneContentsRegister.class);
	/** Reci[ĂXg[WɃANZX邽߂̃C^[tF[X */
	private ContentsAccessor accessor = null;
	/** ̃C^[tF[XLǂ */
	private boolean activeFlag = false;
	/** RecWX^ */
	private final String rkey;

	/**
	 * RXgN^D
	 * @param config [JRecǗVXẽRtBO[V
	 * @param connstr ڑ
	 */
	public StandAloneContentsRegister(RSSLCConfig config) {
		try {
			Properties initparam = new Properties();
			initparam.setProperty(PARAM_ACCESSOR_CLASSNAME, config.getContentsAccessor());
			initparam.setProperty(PARAM_DSR_URI, config.getRssDsr());
			initparam.setProperty(PARAM_INIT_PARAM, config.getContentsConnStr());
			initparam.setProperty(PARAM_CONTENTS_ENCODING, config.getContentsEncoding());
			ContentsAccessorFactory factory = new ContentsAccessorFactory(initparam);
			accessor = factory.getAccessor();
			activeFlag = true;
		} catch(ClassNotFoundException e) {
			activeFlag = false;
			log.error("RecANZX̂߂̃C^[tF[X擾ł܂ł");
		} finally {
			rkey = "localreg_" + RandomKeyGenerator.getUniqKey();
		}
	}

	/**
	 * RecWX^ԂD
	 * @return RecWX^
	 */
	public String getRegisterName() {
		return rkey;
	}
	/**
	 * Reco^D
	 * @param contents Rec
	 */
	public void registContents(WebContents contents) {
		if(contents == null || isActive() == false) {
			return;
		}
		try {
			accessor.regist(contents);
		} catch(Exception e) {
			log.warn("Rec̓o^Ɏs܂:" + ExceptionUtils.stackTraceToString(e));
		}
	}

	/**
	 * Reco^Ă邩ǂԂD
	 * @param url URL
	 * @return true:o^Ă / false:o^ĂȂ
	 */
	public boolean isRegistered(String url) {
		if(isActive() == false) {
			return false;
		}
		try {
			return accessor.find(url) != null ? true : false;
		} catch(Exception e) {
			return false;
		}
	}

	/**
	 * Rec̓o^D
	 * @param url o^URL
	 */
	public void unregistContents(String url) {
		if(isActive() == false) {
			return;
		}
		try {
			accessor.unregist(url);
		} catch(Exception e) {
		}
	}

	/**
	 * o^ĂSẴRec폜D
	 */
	public void unregistAll() {
		if(isActive() == false) {
			return;
		}
		try {
			accessor.unregistAll();
		} catch(Exception e) {
		}
	}

	/**
	 * ̃WX^I/FLǂԂ
	 * @return true:L / false:
	 */
	private boolean isActive() {
		return activeFlag;
	}
	/**
	 * Reco^NCAg~D
	 * @throws RemoteException ~Ɏs
	 */
	public void shutdown() {
		accessor.close();
	}
}
