/*
 * $Id: XMLPersister.java,v 1.3 2006/01/28 03:37:07 rampil Exp $
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 *
 */
package org.logical_paradox.rss.lcmgr.persister;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.logical_paradox.rss.http.WebContents;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/**
 * XMLPersister
 * webRec̕\郁^f[^XMLɕϊāCic[D
 * XMLwebRec^f[^𕜌邱Ƃ\ƂD
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.3 $
 */
public class XMLPersister {
	/**
	 * RXgN^D
	 */
	private XMLPersister() {
	}
	/**
	 * webRec^f[^XMLhLgɕϊD
	 * @param webContents webRec^f[^
	 * @return XMLhLg
	 */
	public static final String marshall(WebContents webContents) throws ParserConfigurationException, FactoryConfigurationError, TransformerException {
		DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
		Document document = builder.newDocument();

		// [gvf
		Element rootElement = document.createElement("Contents");
		// hLg
		Element documentElement = document.createElement("Document");
		documentElement.appendChild(document.createTextNode(webContents.getDocument()));
		// hLgP[V
		Element locationElement = document.createElement("Location");
		locationElement.appendChild(document.createTextNode(webContents.getLocation()));
		// hLg^Cg
		Element documentTitleElement = document.createElement("Title");
		documentTitleElement.appendChild(document.createTextNode(webContents.getTitle()));
		// TCg
		Element sitenameElement = document.createElement("SiteName");
		sitenameElement.appendChild(document.createTextNode(webContents.getSitename()));
		// mime^Cv
		Element contentTypeElement = document.createElement("MimeType");
		contentTypeElement.appendChild(document.createTextNode(webContents.getContentType()));

		// XMLhLgc[̐
		rootElement.appendChild(documentElement);
		rootElement.appendChild(locationElement);
		rootElement.appendChild(documentTitleElement);
		rootElement.appendChild(sitenameElement);
		rootElement.appendChild(contentTypeElement);

		document.appendChild(rootElement);

		// XML𕶎ɕϊďo͂
		StringWriter xmlWriter = new StringWriter();

		TransformerFactory tffactory = TransformerFactory.newInstance();
		Transformer transformer = tffactory.newTransformer();
		transformer.setOutputProperty("encoding", "Windows-31J");
		DOMSource src = new DOMSource();
		src.setNode(document);
		StreamResult target = new StreamResult();
		target.setWriter(xmlWriter);
		transformer.transform(src, target);

		return xmlWriter.getBuffer().toString();
	}
	/**
	 * XMLhLg`webRec^f[^𕜌D
	 * @param document XMLhLg
	 * @return ꂽwebRec^f[^
	 */
	public static final WebContents unmarshall(String document) throws ParserConfigurationException, FactoryConfigurationError, SAXException, IOException {
		DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
		ByteArrayInputStream in = new ByteArrayInputStream(document.getBytes());
		Document doc = builder.parse(in);

		WebContents contents = new WebContents();

		Node root = doc.getFirstChild();
		NodeList webContentsElements = root.getChildNodes();

		for(int i = 0; i < webContentsElements.getLength(); i++) {
			Node node = webContentsElements.item(i);
			String nodename = node.getNodeName();
			String nodevalue = node.getFirstChild().getNodeValue();

			if("Document".equals(nodename)) {
				contents.setDocument(nodevalue);
			} else if("Location".equals(nodename)) {
				contents.setLocation(nodevalue);
			} else if("Title".equals(nodename)) {
				contents.setTitle(nodevalue);
			} else if("SiteName".equals(nodename)) {
				contents.setSitename(nodevalue);
			} else if("MimeType".equals(nodename)) {
				contents.setContentType(nodevalue);
			}
			// ȊȌꍇ͖
		}

		return contents;
	}
}
