/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2004 satoshi akabane(akabane@logical-paradox.org)
 * $Id: Lookup.java,v 1.9 2006/01/28 03:37:06 rampil Exp $
 */
package org.logical_paradox.rss.lookup;

import java.rmi.RemoteException;

import org.logical_paradox.rss.Service;
import org.logical_paradox.rss.dsr.RSSDistributedServiceRegistry;

/**
 * L敪U\[Xlbg[NT[rX
 * L敪Uꂽ\[XCOɂĔT[rXłD<br>
 * UꂽT[rXǂ̂悤ȃCt̏ɍ\zCǂ̂悤Ȏdg݂Ŕ邩<br>
 * ̃C^[tF[Xx_[Ɉˑ܂D
 * 
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.9 $
 */
public interface Lookup {
	/**
	 * UT[rXoCh܂D
	 * oCh́CL敪U\[Xlbg[N肵܂D
	 * @param type T[rX̃^Cv
	 * @param o o^IuWFNg
	 * @return ۂɃoChꂽۂ̎ʕ
	 * @throws Exception oChɎs
	 */
	public String bind(int type, Object o) throws Exception;
	/**
	 * UT[rXAoCh܂D
	 * @param type T[rX̃^Cv
	 * @param name o^m[h
	 * @throws Exception AoChɎs
	 */
	public void unbind(int type, String name) throws Exception;
	/**
	 * DSRWXgɓo^
	 * @param dsr DSR̃CX^X
	 * @throws Exception o^Ɏs
	 */
	public void register(RSSDistributedServiceRegistry dsr) throws Exception;
	/**
	 * L敪U\[Xlbg[NC̎ނ̃T[rX𔭌܂D
	 * @param type T[rX̎
	 * @return ꂽT[rX̃X^u
	 * @throws Exception Ɏs
	 */
	public Object lookup(int type) throws Exception;
	/**
	 * wm[hID̃T[rXԂ܂D
	 * @param nodeId m[hID
	 * @return T[rX̃X^v
	 * @throws Exception bNAbvɎs
	 */
	public Service lookup(String nodeId) throws Exception;
	/**
	 * T[rX̃Xg擾
	 * @param type T[rX̃^Cv
	 * @return T[rX̔z
	 * @throws Exception ꗗɎsۂɔO
	 */
	public String[] services(int type) throws Exception;
	/**
	 * ̔T[rX̃oCh^[Qbg(ڑm[h)Ԃ
	 * @return oCh^[Qbg
	 */
	public String getBindTargetName();
	/**
	 * ̔T[rX̃oCh^[Qbgɑ΂āA[eBOe[u̍XVw
	 * @throws Exception XVɔO
	 */
	public void configure() throws Exception;
	/**
	 * [gQƂ݂ɋL
	 * @param stub o^Ă炤X^u
	 * @throws RemoteException o^Ɏs
	 */
	public Service hug(Service stub) throws Exception;
	/**
	 * [gQƂ݂ɋL
	 * o^𖾎IɎwł
	 * @param stub o^Ă炤X^u
	 * @param name T[rX
	 * @return RemoteException o^Ɏs
	 */
	public Service hug(String name, Service stub) throws Exception;
}
