/*
 * $Id: OQS4RConfig.java,v 1.6 2006/01/27 16:39:04 rampil Exp $
 * Copyright (c) 2004 LOGICAL-PARADOX.ORG
 */
package org.logical_paradox.rss.oqs4r;

import java.io.IOException;

import org.logical_paradox.rss.RSSConfig;
import org.logical_paradox.rss.RSSIllegalConfigException;
import org.logical_paradox.rss.RSSNullValueException;
import org.logical_paradox.rss.RSSValueFormatException;

/**
 * oqs4r̃RtBO
 * @author  satoshi akabane@logical-paradox.org
 * @version $Revision: 1.6 $
 */
public class OQS4RConfig extends RSSConfig {
	// UT[rXWXg
	private String dsr;
	// LbV^CAEgb(msec)
	private int cacheExpireSec;
	// v[Oڑ
	private int preparedConnections;
	// Ot@C
	private String runlogFilename;
	// Oݒ
	private boolean runlogSwitch;
	// eXg[h
	private boolean testMode;

	/**
	 * RXgN^
	 * @param fn t@C
	 * @throws IOException RtBOt@C̓ǂݍ݂Ɏs
	 * @throws RSSIllegalConfigException RtBOt@C̓eꍇɔO
	 */
	public OQS4RConfig(String fn) throws IOException, RSSIllegalConfigException {
		super(fn);
	}
	/**
	 * ڑDSRԂD
	 * @return DSR URI
	 */
	public String getDSRName() {
		return dsr;
	}
	/**
	 * LbV̗L(sec)ԂD
	 * @return L(sec)
	 */
	public int getCacheExpireSec() {
		return cacheExpireSec;
	}
	/**
	 * Oo͂邩ǂԂD
	 * @return true: / false:Ȃ
	 */
	public boolean isEnableRunLog() {
		return runlogSwitch;
	}
	/**
	 * Õt@CԂD
	 * @return Ot@C
	 */
	public String getRunLogFilename() {
		return runlogFilename;
	}
	/**
	 * OڑRlNVԂD
	 * @return OڑRlNV
	 */
	public int getPreparedConnections() {
		return preparedConnections;
	}
	/**
	 * eXg[hǂԂD
	 * @return true:eXg[h / false:{ԃ[h
	 */
	public boolean isTestMode() {
		return testMode;
	}
	/**
	 * p[^mF\bh
	 * @return G[bZ[W
	 */
	@Override
	protected String checkResourceVariables() {
		String errmsg = "";

		dsr = getProperty( "RSS_DSR" );
		if( dsr == null ) {
			errmsg += "RSS_DSRw肳Ă܂\n";
		}
		try {
			cacheExpireSec = getPropertyAsInt( "CACHE_EXPIRE_MSEC" );
		} catch(RSSValueFormatException vfe) {
			errmsg += "CACHE_EXPIRE_MSEC̒lsł\n";
		} catch(RSSNullValueException ne) {}
		try {
			preparedConnections = getPropertyAsInt( "PREPARED_CONNECTIONS" );
		} catch(RSSValueFormatException vfe) {
			errmsg += "PREPARED_CONNECTIONS̒lsł\n";
		} catch(RSSNullValueException ne) {}

		runlogFilename = getProperty("OQS4R_RUNLOG_FILENAME");
		try {
			runlogSwitch = getPropertyAsBool( "OQS4R_RUNLOG_SW" );
		} catch(RSSValueFormatException vfe) {
			errmsg += "OQS4R_RUNLOG_SW̒lsł\n";
		} catch(RSSNullValueException ne) {}
		try {
			testMode = getPropertyAsBool( "TEST_MODE" );
		} catch(RSSValueFormatException vfe) {
			errmsg += "TEST_MODE̒lsł\n";
		} catch(RSSNullValueException ne) {}
		return errmsg;
	}


}
