/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2004 satoshi akabane(akabane@logical-paradox.org)
 *
 */
package org.logical_paradox.rss.rcm;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logical_paradox.rss.rcm.accessor.ContentsAccessor;

/**
 * RCMRec擾NCAgC^[tF[XD<br>
 * ContentsAccessor[gJ邽߂̃bp[݂Ȃ
 * 
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.6 $
 */
public class ContentsFinderImpl extends UnicastRemoteObject implements ContentsFinder {
	/** VAo[WUID */
	private static final long serialVersionUID = -128060723137141161L;

	/** K[ */
	private static final Log log = LogFactory.getLog(ContentsFinderImpl.class);

	private final String name;
	private final ContentsAccessor accessor;

	/**
	 * RXgN^
	 * @param name Rect@C_[̖
	 * @param a RecANZT
	 * @throws RemoteException
	 */
	public ContentsFinderImpl(String n, ContentsAccessor a) throws RemoteException {
		super();
		name = n;
		accessor = a;
	}
	/**
	 * RecɃANZX
	 * @param url 擾URL
	 * @return Rec̕\(Unicode BigEndian)
	 * @throws RemoteException Rec̎擾Ɏs
	 */
	public String getContents(String url) throws RemoteException {
		log.info("[" + url + "]̃Recv܂");
		return accessor.find(url);
	}
	/**
	 * Rect@C_[̖̂Ԃ
	 * @return 
	 * @throws RemoteException ̂̎擾Ɏs
	 */
	public String getName() throws RemoteException {
		return name;
	}

}
