/*
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2006 satoshi akabane(akabane@logical-paradox.org)
 * $Id: RCMContentsRegisterImpl.java,v 1.6 2006/01/27 16:39:04 rampil Exp $
 */
package org.logical_paradox.rss.rcm;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logical_paradox.rss.http.WebContents;
import org.logical_paradox.rss.rcm.accessor.ContentsAccessor;

/**
 * RCMContentsRegisterImpl
 * WebRecT[o[ƒʐM邽߂̃Reco^NCAgIuWFNg
 * WebRecT[o[œ삷
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.6 $
 */
public class RCMContentsRegisterImpl extends UnicastRemoteObject implements RCMContentsRegister {
	/** VAo[WUID */
	private static final long serialVersionUID = -3491241043496340100L;

	/** K[ */
	private static final Log log = LogFactory.getLog(RCMContentsRegisterImpl.class);

	protected ContentsAccessor accessor = null;				// Recf[^ɃANZX邽߂̃C^[tF[XIuWFNg
	protected RSSRCMConfig cfg = null;						// RecǗVXe̐ݒ
	private final String rkey;								// ̃C^[tF[XŗL̃L[
	private ContentsStoreAgent[] agents = null;				// Reco^G[WFg


	/**
	 * RXgN^
	 * ɂ̓Recf[^ւ̃ANZX@C^[tF[Xw肷
	 */
	public RCMContentsRegisterImpl(String registerName, RSSRCMConfig conf, ContentsAccessor a) throws RemoteException {
		rkey = registerName;
		accessor = a;
		cfg = conf;

		log.info("WX^T[rX[" + rkey + "]Ă܂");

		// Reco^G[WFg𐶐
		agents = new ContentsStoreAgent[ cfg.getAgentsPerRegister() ];
		for(int i = 0; i < agents.length; i++) {
			agents[i] = new ContentsStoreAgent(a, cfg);
		}

		log.info("Reco^G[WFg" + agents.length + "܂");

		log.info("WX^T[rX[" + rkey + "]ƂOō쐬܂");

		// G[WFg̎sJn
		start();
	}

	/**
	 * Reco^G[WFgJn
	 * ̃\bh̓[g͎gpłȂ
	 */
	protected void start() {
		for(int i = 0; i < agents.length; i++) {
			agents[i].start();
		}

		log.info("Reco^G[WFgJn܂");
	}
	/**
	 * Reco^G[WFg~
	 * ̃\bh̓[g͎gpłȂ
	 */
	protected void stop() {
		try {
			for(ContentsStoreAgent agent : agents) {
				agent.done();
			}
			for(ContentsStoreAgent agent : agents) {
				agent.join();
			}
		} catch(InterruptedException ie) {}
		log.info("Reco^G[WFg~܂");
	}

	/**
	 * RecWX^T[rX̌ŗLԂ
	 */
	public String getRegisterName() throws RemoteException {
		return rkey;
	}
	/**
	 * Reco^
	 * @param contents Recf[^
	 * @throws RemoteException o^Ɏs
	 */
	public void registContents(WebContents contents) throws RemoteException {
		try {
			// o^
			cfg.getContentsQueue().enqueue(contents);
		} catch(Exception e) {
			throw new RemoteException(e.getMessage());
		}
	}

	/**
	 * Reco^Ă邩ǂ𒲂ׂ
	 */
	public boolean isRegistered(String url) throws RemoteException {
		try {
			// 
			if(accessor.find(url) == null) {
				return false;
			} else {
				return true;
			}
		} catch(Exception e) {
			throw new RemoteException(e.getMessage());
		}
	}

	/**
	 * Rec̓o^
	 */
	public void unregistContents(String url) throws RemoteException {
		try {
			accessor.unregist(url);
		} catch(Exception e) {
			throw new RemoteException(e.getMessage());
		}
	}

	/**
	 * SẴRec폜
	 */
	public void unregistAll() throws RemoteException {
		try {
			accessor.unregistAll();
		} catch(Exception e) {
			throw new RemoteException(e.getMessage());
		}
	}

	/**
	 * ̃C^[tF[XŗLIDԂ
	 */
	public String getRegisterKey() throws RemoteException {
		return rkey;
	}

	/**
	 * Reco^NCAg~D
	 * @throws RemoteException ~Ɏs
	 */
	public void shutdown() throws RemoteException {
		stop();
	}
}

// end of RCMContentsRegisterImpl.java
